package itez.plat.main.model;

import itez.core.runtime.EContext;
import itez.core.runtime.auth.AuthMode;
import itez.core.runtime.auth.AuthService;
import itez.core.runtime.auth.AuthCode;
import itez.kit.ERegex;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.main.model.base.BaseMenu;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Menu extends BaseMenu<Menu> {
	
	/**
	 * 获得菜单的实际链接地址
	 * @return
	 */
	public String getLink(){
		String link = this.getCommand();
		String pattern = "([a-zA-Z_]+)\\:";
		String cmd = ERegex.findFirst(link, pattern);
		if(cmd == null) return link;
		link = link.replaceFirst(pattern, "%s");
		String path = "";
		if(cmd.equals("src")){
			path = EContext.getAttr().getSrc();
		}
		link = String.format(link, path);
		return link;
	}
	
	/**
	 * 菜单鉴权
	 * @return
	 */
	public Boolean authCheck(){
		AuthMode mode = new AuthMode();
		String m = getAuthMode();
		if(EStr.isEmpty(m)){
			return true;
		}else{
			AuthCode code = AuthCode.valueOf(m);
			if(code == AuthCode.REQ_PERM || code == AuthCode.REQ_ROLE){
				mode.setAuthId(getAuthCode());
			}else if(code == AuthCode.REQ_PERMS || code == AuthCode.REQ_ROLES || code == AuthCode.REQ_PERMS_ANY || code == AuthCode.REQ_ROLES_ANY){
				mode.setAuthIds(EStr.toArray(getAuthCode()));
			}
			mode.setAuthCode(code);
			Result valiRet = AuthService.authValidator(mode);
			return valiRet.getState();
		}
	}
	
}
