package itez.plat.main.controller;

import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.kit.restful.Result;
import itez.plat.main.ModuleConfig;
import itez.plat.main.model.TpApi;
import itez.plat.main.service.TpApiService;
import itez.plat.wrapper.controller.EControllerMgr;
import itez.tp.ApiCommon.MODE;
import itez.tp.ApiCommon.TP;
import itez.tp.Loader;

/**
 * 第三方平台配置
 * @author netwild
 *
 */
@AuthRequire.Role(value = ModuleConfig.RoleHighAdmin)
@ControllerDefine(key = "/tp", summary = "第三方平台配置", view = "/sup/tp")
public class TpController extends EControllerMgr {

	@Inject
	TpApiService tpSer;
	
	public void index(){
		List<Loader> list = tpSer.getList();
		setAttr("code", getClean("code", list.get(0).getCode()));
		setAttr("tps", EJson.toJson(list));
		render("index.html");
	}
	
	public void getItem(){
		String code = getClean("code");
		TP tp = TP.valueOf(code);
		Loader loader = tp.getLoader();
		TpApi api = tpSer.getApiModel(tp);
		Boolean enable;
		String mode;
		EMap data;
		if(null == api){
			enable = loader.proxyAble() || loader.shareAble();
			mode = loader.proxyAble() ? MODE.proxy.name() : loader.shareAble() ? MODE.share.name() : MODE.own.name();
			data = null;
		}else{
			enable = api.getEnable();
			mode = api.getMode();
			JSONObject dataJson = JSON.parseObject(api.getData());
			loader.getSecrets().forEach(f -> dataJson.remove(f));
			data = EMap.parseJsonObject(dataJson);
		}
		Result ret = Result.success("code", loader.getCode())
				.set("caption", loader.getCaption())
				.set("summary", loader.getSummary())
				.set("cols", loader.getCols())
				.set("enable", enable)
				.set("proxyAble", loader.proxyAble())
				.set("shareAble", loader.shareAble())
				.set("mode", mode)
				.set("data", data);
		renderJson(ret);
	}
	
	public void event(){
		EMap params = paramPack().getParas().cleanAll();
		String code = params.getStr("code");
		TP tp = TP.valueOf(code);
		params.decrypt(tp.getLoader().getSecrets().toArray(new String[0]));
		
		TpApi api = tpSer.getApiModel(tp);
		if(null == api){
			EMap data = EMap.create();
			tp.getLoader().getFields().forEach(f -> data.set(f, params.getStr(f)));
			api = params.getModel(TpApi.class);
			api.setDomain(attr().getDomain()).setData(data.toJson());
			tpSer.save(api);
		}else{
			JSONObject dbData = JSON.parseObject(api.getData());
			JSONArray colsArr = JSON.parseArray(tp.getLoader().getCols());
			EMap data = EMap.create();
			for(int i = 0, l = colsArr.size(); i < l; i++){
				JSONObject col = colsArr.getJSONObject(i);
				String field = col.getString("field");
				String type = EStr.ifEmpty(col.getString("type"), "text");
				String v = params.getStr(field);
				if(EStr.isEmpty(v) && type.equals("password")) v = dbData.getString(field);
				data.set(field, v);
			}
			Boolean enable = params.getStr("enable").equals("true");
			String mode = params.getStr("mode");
			api.setEnable(enable).setMode(mode).setData(data.toJson());
			tpSer.update(api);
		}
		renderJson(Result.success());
	}
	
}
