/**
 * SupSqlController.java
 */
package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.dbo.exec.DbExec;
import itez.core.wrapper.dbo.exec.DbResult;
import itez.kit.EJson;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.main.model.Module;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.TerminalEnvsService;
import itez.plat.main.service.TerminalService;
import itez.plat.wrapper.controller.EControllerSup;

/**
 * <p>
 * 数据库SQL执行控制器
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年4月14日 上午10:24:16
 */
@ControllerDefine(key = "/sup/sql", summary = "数据管理", view = "/sup/sql")
public class SupSqlController extends EControllerSup {

	@Inject
	TerminalService terSer;

	@Inject
	TerminalEnvsService envSer;
	
	@Inject
	ModuleService moduleSer;
	
	public void index(){
		List<Module> modules = moduleSer.getByComp();
		setAttr("modules", EJson.toJson(modules));
		render("index.html");
	}
	
	public void event(String moduleCode, String sql){
		if(EStr.isEmpty(moduleCode) || EStr.isEmpty(sql)){
			renderJson(Result.fail("缺少参数"));
			return;
		}
		try {
			DbResult res = DbExec.execute(moduleCode, sql);
			renderJson(Result.success("result", res));
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
}
