package itez.plat.main.controller;

import java.io.File;
import java.util.List;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EDate;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.poi.XlsHeader;
import itez.kit.poi.XlsHeaderItem;
import itez.kit.poi.XlsWriter;
import itez.kit.restful.Result;
import itez.plat.main.ModuleConfig;
import itez.plat.main.model.Module;
import itez.plat.main.model.Perm;
import itez.plat.main.model.Role;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.PermService;
import itez.plat.main.service.RoleService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Role(value = ModuleConfig.RoleBaseAdmin)
@ControllerDefine(key = "/auth/role", summary = "角色管理", view = "/auth")
public class RoleController extends EControllerMgr {
	
	@Inject
	RoleService roleSer;
	
	@Inject
	PermService permSer;
	
	@Inject
	ModuleService moduleSer;

	public void index(String moduleCode){
		List<Module> modules = moduleSer.getByComp();
		if(EStr.isEmpty(moduleCode)) moduleCode = modules.get(0).getCode();
		setAttr("moduleCode", moduleCode);
		setAttr("modules", EJson.toJsonFilter(modules, "code", "caption"));
		render("role.html");
	}
	
	public void getData(String moduleCode){
		List<Perm> perms = permSer.getByModule(moduleCode);
		List<Role> roles = roleSer.getByModule(moduleCode);
		renderJson(Result.success("perms", perms).set("roles", roles));
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		Role role = paras.getModel(Role.class);
		if(EStr.isEmpty(role.getId())){
			Role exist = roleSer.findByCode(role.getCode());
			if(exist != null){
				renderJson(Result.fail("角色代码已存在！"));
				return;
			}
			roleSer.save(role);
		}else{
			roleSer.update(role);
		}
		renderJson(Result.success());
	}
	
	public void remove(String id){
		roleSer.deleteById(id);
		renderJson(Result.success());
	}
	
	public void exports(String moduleCode){
		List<Role> list = roleSer.getByModule(moduleCode);
		List<Record> recs = parseRecords(list);
		String fileName = "角色清单（".concat(moduleCode).concat("）").concat(EDate.format(EDate.getDate(), "yyyyMMddHHmmss")).concat(".xls");
		XlsWriter xls = XlsWriter.create(fileName);
		XlsHeader header = XlsHeader.create();
		header.addItem(new XlsHeaderItem("code", "角色别名"));
		header.addItem(new XlsHeaderItem("caption", "角色名称"));
		header.addItem(new XlsHeaderItem("summary", "描述"));
		header.addItem(new XlsHeaderItem("permIds", "包含权限"));
		xls.putSheet("Sheet1", recs, header);
		xls.generator();
		render(xls); //浏览器下载
	}
	
	public void importsEvent(){
		EPara paras = paramPack(false);
		String moduleCode = paras.get("moduleCode");
		boolean repeatCode = paras.getInt("repeatCode") == 1;
		File file = paras.getFileObj("file");
		try {
			int cnt = roleSer.imports(moduleCode, file, repeatCode);
			renderJson(Result.success("cnt", cnt));
		} catch (Exception e) {
			renderJson(Result.fail("导入失败！<br>" + e.getMessage()));
		}
	}
	
}
