package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.restful.EMap;
import itez.kit.restful.Result;
import itez.plat.main.ModuleConfig;
import itez.plat.main.service.PolicyService;
import itez.plat.main.service.impl.PolicyServiceImpl.POLICYS;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Role(value = ModuleConfig.RoleHighAdmin)
@ControllerDefine(key = "/sup/policy", summary = "安全策略管理", view = "/sup/policy")
public class PolicyController extends EControllerMgr {

	@Inject
	PolicyService policySer;
	
	public void index(){
		List<EMap> policys = policySer.getPolicyList();
		String type = getPara(0, policys.get(0).getStr("code"));
		setAttr("type", type);
		setAttr("policys", EJson.toJson(policys));
		render("index.html");
	}
	
	public void getData(String type){
		List<Record> list = policySer.getDetails(POLICYS.valueOf(type));
		renderJson(Result.success("list", list));
	}
	
	public void update(String type){
		EPara paras = paramPack();
		try {
			policySer.modify(POLICYS.valueOf(type), paras);
			renderJson(Result.success());
		} catch (Exception e) {
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
	public void remove(String type, String code){
		try {
			policySer.remove(POLICYS.valueOf(type), code);
			renderJson(Result.success());
		} catch (Exception e) {
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
}
