package itez.plat.main.controller;

import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.inject.Inject;
import com.jfinal.aop.Clear;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;
import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.ELog;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.EWeb;
import itez.kit.log.ELogBase;
import itez.kit.pay.PayKit;
import itez.kit.pay.PayKit.Channel;
import itez.kit.restful.EMap;
import itez.kit.restful.Result;
import itez.kit.pay.PayOver;
import itez.plat.main.ModuleConfig;
import itez.plat.main.model.PaymentChannel;
import itez.plat.main.model.PaymentIsv;
import itez.plat.main.service.PaymentChannelService;
import itez.plat.main.service.PaymentIsvService;
import itez.plat.main.service.PaymentIsvService.STYPE;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Role(value = ModuleConfig.RoleHighAdmin)
@ControllerDefine(key = "/payment", summary = "支付渠道设置", view = "/")
public class PaymentController extends EControllerMgr {

	private static PayOver PayOverRet = null;
	ELogBase log = ELog.log(PaymentController.class);

	@Inject
	PaymentChannelService paySer;
	
	@Inject
	PaymentIsvService isvSer;
	
	public void index(String code){
		List<Record> channels = paySer.getPaymentChannels();
		if(EStr.isEmpty(code)) code = channels.get(0).getStr("code");
		PayKit.Channel channel = Channel.valueOf(code);
		String config = PayKit.me.paramConfig(channel);
		
		PaymentChannel payChannel = paySer.findByCode(code);
		if(payChannel == null) payChannel = new PaymentChannel().setCode(code).setCaption(channel.getCaption()).setEnable(0);
		String payParams = payChannel.getParams();
		
		//处理表单字段配置及当前值，如果是password类型，则不向客户端输出，同时修改字段配置为选填项，提示缴费接口安全性，避免敏感信息泄露
		JSONArray confs = JSON.parseArray(config);
		if(EStr.notEmpty(payParams)){
			JSONObject paras = JSON.parseObject(payParams);
			for(int i=0, len=confs.size(); i<len; i++){
				JSONObject conf = confs.getJSONObject(i);
				String field = conf.getString("field");
				String type = EStr.ifEmpty(conf.getString("type"), "");
				if(type.equals("password")){
					paras.remove(field);
					conf.put("placeholder", "此处为敏感数据已隐藏。如果无需修改请留空");
					conf.put("required", false);
				}
			}
			payParams = paras.toJSONString();
		}else{
			payParams = EJson.toJson(payChannel);
		}

		setAttr("channels", EJson.toJson(channels));
		setAttr("paramConfig", confs.toJSONString());
		setAttr("payment", payParams);
		render("payment.html");
	}
	
	public void formEvent(){
		String code = get("code");
		String caption = get("caption");
		Integer enable = getInt("enable");
		PaymentChannel payChannel = paySer.findByCode(code);
		EMap params = paramPack().getParas();

		if(payChannel == null){
			payChannel = new PaymentChannel();
			payChannel.setCode(code).setCaption(caption).setEnable(enable).setParams(params.toJson()).setSort(0);
			paySer.save(payChannel);
		}else{
			String payParams = payChannel.getParams();
			PayKit.Channel channel = Channel.valueOf(code);
			String config = PayKit.me.paramConfig(channel);
			
			//如果是修改配置，则对password类型的字段进行处理，如果为空，则将原有值填充到待更新的表单中
			JSONObject paras = JSON.parseObject(payParams);
			JSONArray confs = JSON.parseArray(config);
			for(int i=0, len=confs.size(); i<len; i++){
				JSONObject conf = confs.getJSONObject(i);
				String field = conf.getString("field");
				String type = EStr.ifEmpty(conf.getString("type"), "");
				if(type.equals("password") && EStr.isEmpty(params.getStr(field))){
					params.set(field, paras.getString(field));
				}
			}
			
			payChannel.setEnable(enable).setParams(params.toJson());
			paySer.update(payChannel);
		}
		redirect(attr().getCtrl().concat("?code=").concat(code));
	}
	
	public void debug(String code, String amount){
		String errMsg = "";
		String qrCode = "";
		String orderId = "DEBUG_".concat(EUid.generator()); //订单号
		String payment = EStr.ifEmpty(amount, "0.01"); //一分钱
		List<Record> channels = paySer.getPaymentChannels();
		if(EStr.isEmpty(code)) code = channels.get(0).getStr("code");
		
		PaymentChannel payModel = paySer.findByCode(code);
		if(payModel == null || EStr.isEmpty(payModel.getParams())){
			errMsg = "请先将支付渠道相关参数设置完成";
		}else{
			JSONObject configs = JSON.parseObject(payModel.getParams());
			try {
				qrCode = PayKit.me.getQrCode(configs, orderId, payment, "", "");
			} catch (Exception e) {
				errMsg = e.getMessage();
			}
		}
		setAttr("channels", EJson.toJson(channels));
		setAttr("code", code);
		setAttr("qrCode", qrCode);
		setAttr("errMsg", errMsg);
		setAttr("orderId", orderId);
		setAttr("payment", payment);
		render("payment-debug.html");
	}

	@Clear
	@AuthRequire.Guest
	public void debugQr(String qrCode){
		renderQrCode(qrCode, 200, 200);
	}

	@Clear
	@AuthRequire.Guest
	public void vali(String orderId){
		if(PayOverRet == null){
			renderNull();
			return;
		}
		if(PayOverRet.getState()){
			renderJson(Result.success());
		}else{
			renderJson(Result.fail(PayOverRet.getMsg()));
		}
		PayOverRet = null;
	}

	@Clear
	@AuthRequire.Guest
	public void callback(){
		String code = PayKit.Channel.CCB.name();
		log.info("接收到缴费调试的回调信息，渠道：{}", code);
		
		PaymentChannel payModel = paySer.findByCode(code);
		JSONObject configs = JSON.parseObject(payModel.getParams());
		EPara paras = paramPack();
		PayOver ret = PayKit.me.callback(configs, paras);
		log.info("验签结果：{}（{}）", ret.getState(), ret.getMsg());
		PayOverRet = ret;
		
		renderText(ret.getRender());
	}

	@Clear
	@AuthRequire.Guest
	public void callbackWx(){
		String code = PayKit.Channel.WX.name();
		log.info("接收到缴费调试的回调信息，渠道：{}", code);
		
		PaymentChannel payModel = paySer.findByCode(code);
		JSONObject configs = JSON.parseObject(payModel.getParams());
		EPara paras = paramPack();
		PayOver ret = PayKit.me.callback(configs, paras);
		log.info("验签结果：{}（{}）", ret.getState(), ret.getMsg());
		PayOverRet = ret;
		
		renderText(ret.getRender());
	}

	@Clear
	@AuthRequire.Guest
	public void callbackAli(){
		String code = PayKit.Channel.ALI.name();
		log.info("接收到缴费调试的回调信息，渠道：{}", code);
		
		PaymentChannel payModel = paySer.findByCode(code);
		JSONObject configs = JSON.parseObject(payModel.getParams());
		EPara paras = paramPack();
		PayOver ret = PayKit.me.callback(configs, paras);
		log.info("验签结果：{}（{}）", ret.getState(), ret.getMsg());
		PayOverRet = ret;
		
		renderText(ret.getRender());
	}
	
	/**
	 * <p>
	 * 支付宝授权申请
	 * </p>
	 *
	 */
	public void isvAliAuth(){
		PaymentIsv isv = isvSer.getByType(STYPE.ALI);
		if(isv == null) isv = new PaymentIsv().setEnable(false);
		String state = EWeb.UrlEncoder(attr().getCtrl() + "/isvAliBack");
		Prop prop = PropKit.use("isv_ali.properties");
		String url = prop.get("RETURN_URL") + "/auth?state=" + state;
		setAttr("isv", EJson.toJson(isv));
		setAttr("url", url);
		render("payment-isv-ali.html");
	}
	
	/**
	 * <p>
	 * 授权模式开启/关闭
	 * </p>
	 *
	 */
	public void isvAliEnable(Boolean enable){
		PaymentIsv isv = isvSer.getByType(STYPE.ALI);
		if(EStr.isEmpty(isv.getId())){
			renderJson(Result.fail("请先进行授权！"));
			return;
		}
		isv.setEnable(enable);
		isvSer.update(isv);
		renderJson(Result.success());
	}
	
	/**
	 * <p>
	 * 支付宝授权回调
	 * </p>
	 *
	 */
	public void isvAliBack(String uid, String appid, String token){
		PaymentIsv isv = isvSer.getByType(STYPE.ALI);
		isv.setUid(uid);
		isv.setAppid(appid);
		isv.setToken(token);
		isvSer.saveOrUpdate(isv);
		redirect(attr().getCtrl() + "/isvAliAuth");
	}
	
}
