package itez.plat.main.controller;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EDate;
import itez.kit.EFile;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EProp;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.fileup.EFileFactory;
import itez.kit.restful.Result;
import itez.plat.main.ModuleConfig;
import itez.plat.main.model.Menu;
import itez.plat.main.model.Module;
import itez.plat.main.model.Perm;
import itez.plat.main.model.Role;
import itez.plat.main.service.MenuService;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.PermService;
import itez.plat.main.service.RoleService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Role(value = ModuleConfig.RoleBaseAdmin)
@ControllerDefine(key = "/menu", summary = "菜单管理", view = "/")
public class MenuController extends EControllerMgr {
	
	@Inject
	MenuService menuSer;
	
	@Inject
	ModuleService moduleSer;
	
	@Inject
	RoleService roleSer;
	
	@Inject
	PermService permSer;
	
	public void index(){
		String mtype = getPara("mtype", "menu");
		List<Module> modules = moduleSer.getByComp();
		List<Role> roles = roleSer.getByComp();
		List<Perm> perms = permSer.getByComp();
		List<Menu> menus = menuSer.getMenuTree(mtype);
		setAttr("mtype", mtype);
		setAttr("modules", EJson.toJsonFilter(modules, "code", "caption"));
		setAttr("roles", EJson.toJsonFilter(roles, "code", "caption", "moduleId"));
		setAttr("perms", EJson.toJsonFilter(perms, "code", "caption", "moduleId"));
		setAttr("menus", EJson.toJson(menus));
		render("menu.html");
	}
	
	/**
	 * <p>
	 * 添加或修改单条
	 * </p>
	 *
	 */
	public void singleEvent(){
		EPara paras = paramPack();
		String mtype = paras.getClean("mtype");
		Menu menu = paras.getModel(Menu.class);
		if(EStr.isEmpty(menu.getAuthMode()) || menu.getAuthMode().equals("-")){
			menu.setAuthMode(null);
			menu.setAuthCode(null);
		}
		String pid = menu.getPid();
		menu.setPid(EStr.isEmpty(pid) ? null : pid);
		if(EStr.isEmpty(menu.getId())){
			menuSer.save(menu);
			menuSer.arrange(Querys.and(Query.eq("mtype", mtype)), menu.getId());
		}else{
			menuSer.update(menu);
		}
		List<Menu> menus = menuSer.getMenuTree(mtype);
		renderJson(Result.success("menus", menus));
	}
	
	/**
	 * <p>
	 * 批量修改
	 * </p>
	 *
	 */
	public void batchEvent(){
		EPara paras = paramPack();
		String ids = paras.getClean("ids");
		String moduleCode = paras.get("moduleCode");
		String authMode = paras.get("authMode");
		String[] authCodes = paras.getValues("authCode");
		
		String authCode;
		if(EStr.isEmpty(authMode) || authMode.equals("-")){
			authMode = null;
			authCode = null;
		}else{
			authCode = EStr.parseArray(authCodes);
		}
		List<Menu> ups = menuSer.findByIds(ids);
		for(Menu m : ups) m.setModuleCode(moduleCode).setAuthMode(authMode).setAuthCode(authCode);
		menuSer.batchUpdate(ups);
		
		List<Menu> menus = menuSer.getMenuTree(paras.get("mtype"));
		renderJson(Result.success("menus", menus));
	}
	
	public void remove(){
		String mtype = getPara("mtype", "menu");
		String ids = getPara("ids");
		String[] idArr = ids.split(",");
		Arrays.stream(idArr).forEach(id -> {
			Menu m = menuSer.findById(id);
			menuSer.delMenuByPath(mtype, m.getPath());
		});
		List<Menu> menus = menuSer.getMenuTree(mtype);
		renderJson(Result.success("menus", menus));
	}
	
	public void sort(){
		String mtype = getPara("mtype", "menu");
		String pid = getPara("pid");
		String opt = getPara("opt");
		String ids = getPara("ids");
		menuSer.sort(mtype, pid, opt, ids);
		List<Menu> menus = menuSer.getMenuTree(mtype);
		renderJson(Result.success("menus", menus));
	}
	
	/**
	 * <p>
	 * 移动
	 * </p>
	 * 
	 * @param ids
	 * @param pid
	 */
	public void move(String mtype, String ids, String pid){
		List<Menu> ms = menuSer.getByIds(ids, "asc");
		ms.forEach(m -> {
			m.setPid(pid);
			menuSer.update(m);
			menuSer.arrange(Querys.and(Query.eq("mtype", mtype)), m.getId());
		});
		List<Menu> menus = menuSer.getMenuTree(mtype);
		renderJson(Result.success("menus", menus));
	}
	
	public void export(){
		List<Menu> menus = menuSer.getCompMenus("menu", null, true);
		String menuJson = EJson.format(EJson.toJson(menus));
		String folderPath = String.format("%s/%s/menu", EFileFactory.me.getLocalTempPath(), attr().getDomain());
		File oPath = new File(folderPath);
		if(!oPath.exists()) oPath.mkdirs();
		String filePath = String.format("%s/menu-%s.json", folderPath, EDate.format(EDate.getDate(), "yyyyMMddHHmmss"));
		File oFile = new File(filePath);
		try {
			oFile.createNewFile();
			EFile.write(oFile, menuJson);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
		}
		renderFile(oFile);
	}
	
	public void init(){
		String mtype = getPara("mtype", "menu");
		String module = getPara("module", "module");
		try {
			menuSer.init(null, mtype, module);
			renderJson(ERet.ok());
		} catch (Exception e) {
			renderJson(ERet.fail(e.getMessage()));
		}
	}

}
