package itez.plat.main.controller;

import java.io.File;
import java.util.Arrays;
import java.util.Map;

import com.google.inject.Inject;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.upload.UploadFile;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.poi.EPoi;
import itez.kit.poi.Excel;
import itez.plat.main.service.ImportService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/import", summary = "数据导入", view = "/import")
public class ImportController extends EControllerMgr {

	private final static String SESSION_KEY_CLAZZ = "imp_clazz";
	private final static String SESSION_KEY_IGNORES = "imp_ignores";
	private final static String SESSION_KEY_REFER = "imp_refer";
	private final static String SESSION_KEY_PARAM = "imp_param";

	@Inject
	ImportService importSer;
	
	public void index(){
		String clazz = getPara("clazz");													// Model类
		String ignores = getPara("ignores");												// 忽略字段（多个时用_隔开）
		String refer = getPara("refer", attr().getRequestReferer());						// 导入完成后返回页面
		String params = getPara("params", paramSerialize("clazz", "refer", "ignores"));		// 其他参数
		if(EStr.notEmpty(clazz)){
			session().setAttribute(SESSION_KEY_CLAZZ, clazz);
			session().setAttribute(SESSION_KEY_IGNORES, ignores);
			session().setAttribute(SESSION_KEY_REFER, EStr.ifNull(refer, ""));
			session().setAttribute(SESSION_KEY_PARAM, params);
		}
		render("index.html");
	}
	
	public void options(){
		UploadFile upFile = getFile("excel");
		String fileName = upFile.getOriginalFileName();
		String fileType = fileName.substring(fileName.lastIndexOf("."));
		if(!fileType.equals(".xls") && !fileType.equals(".xlsx")){
			setFlashMsg("请上传Excel格式的导入文件。");
			redirect(attr().getCtrl());
			return;
		}
		Excel excel = null;
		try {
			excel = EPoi.load(upFile.getFile(), 3);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			setFlashMsg("解析Excel文件时发送错误，请重新操作。");
			redirect(attr().getCtrl());
			return;
		}
		String filePath = upFile.getFile().getAbsolutePath();

		String clazz = session().getAttr(SESSION_KEY_CLAZZ);
		String params = session().getAttr(SESSION_KEY_PARAM);
		String ignores = session().getAttr(SESSION_KEY_IGNORES);
		Kv formCache = importSer.getFormCache(clazz, params);
		Map<String, String> paramsMap = paramDeserialize(params);
		
		String[] dbConfig = {"", ""};
		TableMeta tableMeta = importSer.parseModel(clazz, dbConfig);
		
		String config = dbConfig[0];
		String tableName = dbConfig[1];
		
		Map<String, Boolean> ignoreFields = importSer.getIgnoreFields();
		if(EStr.notEmpty(ignores)){
			String[] igArr = ignores.split("_");
			Arrays.stream(igArr).forEach(ig -> ignoreFields.put(ig.trim(), Boolean.TRUE));
		}
		
		setAttr("formCache", formCache);				// 字段导入规则缓存
		setAttr("ignoreFields", ignoreFields);			// 忽略字段列表
		setAttr("paramsMap", paramsMap);				// 其他参数
		setAttr("excel", excel);						// EXCEL样例
		setAttr("filePath", filePath);					// EXCEL文件保存路径
		setAttr("config", config);						// 数据源名称
		setAttr("table", tableName);					// 数据表名称
		setAttr("tableMeta", tableMeta);				// 数据结构
		render("options.html");
	}
	
	public void apply(){
		String clazz = session().getAttr(SESSION_KEY_CLAZZ);
		String params = session().getAttr(SESSION_KEY_PARAM);
		String filePath = getPara("filePath");
		Integer sheetIndex = getParaToInt("sheetIndex", 0);
		Integer ignoreHeaders = getParaToInt("ignoreHeaders", 1);
		String[] fields = getParaValues("field");
		String[] modes = getParaValues("mode");
		String[] exprs = getParaValues("expr");
		Excel excel = null;
		try {
			excel = EPoi.load(new File(filePath));
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			setFlashMsg("解析Excel文件时发送错误，请重新操作。");
			redirect(attr().getCtrl());
			return;
		}
		Integer count = importSer.apply(clazz, excel, sheetIndex, ignoreHeaders, fields, modes, exprs);
		importSer.putFormCache(clazz, params, fields, modes, exprs);
		setAttr("refer", session().getAttribute(SESSION_KEY_REFER));
		setAttr("count", count);
		render("result.html");
	}
	
}
