package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthCode;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.DrawingGroup;
import itez.plat.main.model.DrawingModel;
import itez.plat.main.service.DrawingGroupService;
import itez.plat.main.service.DrawingModelService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/drawing/model", summary = "模型管理", view = "/drawing")
public class DrawingModelController extends EControllerMgr {

	@Inject
	DrawingGroupService groupSer;
	
	@Inject
	DrawingModelService modelSer;
	
	public void index(String groupCode){
		List<DrawingGroup> groups = groupSer.selectAll();
		if(groups.size() == 0){
			renderErrHelp(AuthCode.LOGIC, "请先创建分组", attr().getModuleUrl().concat("/drawing/group"));
			return;
		}
		if(EStr.isEmpty(groupCode)) groupCode = groups.get(0).getCode();
		List<DrawingModel> models = modelSer.getByGroupCode(groupCode);
		setAttr("groups", EJson.toJson(groups));
		setAttr("groupCode", groupCode);
		setAttr("models", EJson.toJson(models));
		render("model.html");
	}
	
	public void form(String groupCode, String id){
		DrawingModel model = new DrawingModel().setGroupCode(groupCode);
		boolean newMode = true;
		if(EStr.notEmpty(id)){
			model = modelSer.findById(id);
			newMode = false;
		}
		setAttr("model", EJson.toJson(model));
		setAttr("newMode", newMode);
		render("model-form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		String groupCode = paras.get("groupCode");
		DrawingModel model = paras.getModel(DrawingModel.class);
		if(EStr.notEmpty(paras.getFile("backImage"))) model.setBackImage(paras.getFile("backImage"));
		modelSer.saveOrUpdate(model);
		redirect(attr().getCtrl().concat("?groupCode=").concat(groupCode));
	}
	
	public void remove(String groupCode, String id){
		modelSer.disableByIds(id);
		redirect(attr().getCtrl().concat("?groupCode=").concat(groupCode));
	}
	
}
