package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EStr;
import itez.plat.main.model.DrawingGroup;
import itez.plat.main.service.DrawingGroupService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/drawing/group", summary = "制图分组管理", view = "/drawing")
public class DrawingGroupController extends EControllerMgr {

	@Inject
	DrawingGroupService groupSer;
	
	public void index(){
		List<DrawingGroup> list = groupSer.selectAll();
		setAttr("list", EJson.toJson(list));
		render("group.html");
	}
	
	public void form(String id){
		DrawingGroup model = new DrawingGroup();
		boolean newMode = true;
		if(EStr.notEmpty(id)){
			model = groupSer.findById(id);
			newMode = false;
		}
		setAttr("model", EJson.toJson(model));
		setAttr("newMode", newMode);
		render("group-form.html");
	}
	
	public void formEvent(){
		DrawingGroup model = getBean(DrawingGroup.class, "");
		groupSer.saveOrUpdate(model);
		redirect(attr().getCtrl());
	}
	
	public void remove(String id){
		groupSer.disableByIds(id);
		redirect(attr().getCtrl());
	}
	
}
