package itez.plat.main.controller;

import java.util.List;
import com.google.inject.Inject;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Record;

import itez.core.util.drawing.Board;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.DrawingElement;
import itez.plat.main.model.DrawingModel;
import itez.plat.main.service.DrawingElementService;
import itez.plat.main.service.DrawingModelService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/drawing/element", summary = "制图", view = "/drawing")
public class DrawingElementController extends EControllerMgr {
	
	@Inject
	DrawingModelService modelSer;

	@Inject
	DrawingElementService elSer;
	
	public void index(String modelId){
		List<DrawingElement> list = elSer.getByModelId(modelId, true);
		setAttr("modelId", modelId);
		setAttr("list", EJson.toJson(list));
		render("element.html");
	}
	
	public void form(String modelId, String id){
		DrawingElement model = new DrawingElement().setModelId(modelId);
		boolean newMode = true;
		if(EStr.notEmpty(id)){
			model = elSer.findById(id);
			newMode = false;
		}
		setAttr("model", EJson.toJson(model));
		setAttr("newMode", newMode);
		render("element-form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		String modelId = paras.get("modelId");
		DrawingElement model = paras.getModel(DrawingElement.class);
		elSer.saveOrUpdate(model);
		redirect(attr().getCtrl().concat("?modelId=").concat(modelId));
	}
	
	public void remove(String modelId, String id){
		elSer.deleteById(id);
		redirect(attr().getCtrl().concat("?modelId=").concat(modelId));
	}
	
	public void visible(String modelId, String id, Integer visible){
		DrawingElement el = elSer.findById(id);
		el.setVisible(visible).update();
		redirect(attr().getCtrl().concat("?modelId=").concat(modelId));
	}
	
	public void debug(String modelId){
		List<DrawingElement> els = elSer.getByModelId(modelId);
		String dataStr = elSer.parseFromSet(elSer.getKey4Data(els));
		String paraStr = elSer.parseFromSet(elSer.getKey4Para(els));
		setAttr("modelId", modelId);
		setAttr("data", dataStr);
		setAttr("para", paraStr);
		render("debug.html");
	}
	
	@SuppressWarnings("unchecked")
	public void debugEvent(String modelId, String dataStr, String paraStr, Integer index){
		DrawingModel model = modelSer.findById(modelId);
		Record data = new Record();
		data.setColumns(elSer.parseFromString(dataStr));
		Kv para = elSer.parseFromString(paraStr);
		Board board = modelSer.getBoard("debug", model, data, para, index);
		board.drawing();
		render(board);
	}
	
}
