package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.main.ModuleConfig;
import itez.plat.main.model.DeptType;
import itez.plat.main.service.DeptTypeService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Role(value = ModuleConfig.RoleHighAdmin)
@ControllerDefine(key = "/deptType", summary = "部门类型管理", view = "/")
public class DeptTypeController extends EControllerMgr {

	@Inject
	DeptTypeService typeSer;
	
	public void index(){
		List<DeptType> types = typeSer.selectAll();
		setAttr("types", EJson.toJson(types));
		render("deptType.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		DeptType type = paras.getModel(DeptType.class);
		DeptType exist = typeSer.findByCode(type.getCode());
		if(EStr.isEmpty(type.getId()) && exist != null){
			renderJson(Result.fail("类型代码（" + type.getCode() + "）已存在！"));
			return;
		}else if(exist != null && !type.getId().equals(exist.getId())){
			renderJson(Result.fail("类型代码（" + type.getCode() + "）已存在！"));
			return;
		}
		typeSer.saveOrUpdate(type);
		renderJson(Result.success("type", type));
	}
	
	public void remove(String id){
		try {
			typeSer.disableByIds(id);
			renderJson(Result.success());
		} catch (Exception e) {
			renderJson(Result.fail(e.getMessage()));
		}
	}
	
}
