package itez.plat.main.controller;

import java.io.File;
import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.main.ModuleConfig;
import itez.plat.main.model.Dept;
import itez.plat.main.model.DeptType;
import itez.plat.main.model.User;
import itez.plat.main.service.DeptService;
import itez.plat.main.service.DeptTypeService;
import itez.plat.main.service.UserService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Role(value = ModuleConfig.RoleBaseAdmin)
@ControllerDefine(key = "/dept", summary = "部门管理", view = "/")
public class DeptController extends EControllerMgr {

	@Inject
	DeptService deptSer;

	@Inject
	DeptTypeService typeSer;
	
	@Inject
	UserService userSer;
	
	public void index(){
		User user = (User)session().getUser();
		String rootId = user.getRootDeptId();
		List<DeptType> types = typeSer.selectAll();
		setAttr("rootId", rootId);
		setAttr("types", EJson.toJson(types));
		render("dept.html");
	}
	
	public void getData(String rootId, String pid){
		Result ret = Result.success();
		if(EStr.notEmpty(rootId)){
			List<Dept> deptTree = deptSer.getDeptTree(rootId);
			ret.set("tree", deptTree);
		}
		if(EStr.notEmpty(pid)){
			List<Dept> subs = deptSer.getSubDepts(pid);
			ret.set("subs", subs);
		}
		renderJson(ret);
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		Dept dept = paras.getModel(Dept.class);
		try {
			deptSer.event(dept);
			renderJson(Result.success("dept", dept));
		} catch (Exception e) {
			renderJson(Result.fail(e.getCause().getMessage()));
		}
	}
	
	public void formEventBatch(){
		EPara paras = paramPack();
		try {
			deptSer.eventBatch(paras);
			renderJson(Result.success());
		} catch (Exception e) {
			renderJson(Result.fail(e.getCause().getMessage()));
		}
	}
	
	public void remove(String ids){
		try {
			deptSer.removeDepts(ids);
			renderJson(Result.success());
		} catch (Exception e) {
			renderJson(Result.fail(e.getCause().getMessage()));
		}
	}
	
	public void sort(String pid, String opt, String ids){
		deptSer.sort(pid, opt, ids);
		List<Dept> depts = deptSer.getSubDepts(pid);
		renderJson(Result.success("depts", depts));
	}
	
	/**
	 * <p>
	 * 移动
	 * </p>
	 * 
	 * @param ids
	 * @param pid
	 */
	public void move(String ids, String pid){
		List<Dept> ms = deptSer.getByIds(ids, "asc");
		ms.forEach(m -> {
			m.setPid(pid);
			deptSer.modifyDept(m);
			deptSer.arrange(null, m.getId());
		});
		renderJson(Result.success());
	}
	
	public void imports(String pid){
		Dept parentDept = deptSer.findById(pid);
		setAttr("parentDept", parentDept.keep("id", "caption"));
		render("deptImports.html");
	}
	
	public void importsEvent(){
		EPara paras = paramPack(false);
		String deptId = paras.get("deptId");
		File file = paras.getFileObj("file");
		try {
			int cnt = deptSer.imports(deptId, file);
			setFlashMsg("导入成功，共导入 " + cnt + " 条部门信息。");
			redirect(attr().getCtrl() + "?pid=" + deptId);
		} catch (Exception e) {
			setFlashMsg("导入失败，" + e.getMessage());
			redirect(attr().getCtrl() + "/imports?pid=" + deptId);
		}
	}
	
}
