package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.plat.main.model.ConfigGroup;
import itez.plat.main.model.Module;
import itez.plat.main.service.ConfigGroupService;
import itez.plat.main.service.ModuleService;
import itez.plat.wrapper.controller.EControllerSup;

@ControllerDefine(key = "/config/group", summary = "系统参数分组配置", view = "/config")
public class ConfigGroupCongroller extends EControllerSup {

	@Inject
	ConfigGroupService groupSer;

	@Inject
	ModuleService moduleSer;
	
	public void index(){
		List<ConfigGroup> groups = groupSer.selectAll();
		setAttr("list", EJson.toJson(groups));
		render("group.html");
	}
	
	public void form(String id){
		List<Module> modules = moduleSer.selectAll();//.getByComp();
		ConfigGroup model = EStr.isEmpty(id) ? new ConfigGroup() : groupSer.findById(id);
		setAttr("model", EJson.toJson(model));
		setAttr("modules", EJson.toJsonFilter(modules, "code", "caption"));
		render("group-form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		ConfigGroup model = paras.getModel(ConfigGroup.class);
		groupSer.saveOrUpdate(model);
		redirect(attr().getCtrl());
	}
	
	public void remove(String id){
		groupSer.disable(id);
		redirect(attr().getCtrl());
	}
	
}
