package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Record;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.main.model.ConfigDefault;
import itez.plat.main.model.ConfigGroup;
import itez.plat.main.service.ConfigDefaultService;
import itez.plat.main.service.ConfigGroupService;
import itez.plat.wrapper.controller.EControllerSup;

@ControllerDefine(key = "/config/def", summary = "系统参数默认值", view = "/config")
public class ConfigDefaultController extends EControllerSup {

	@Inject
	ConfigGroupService groupSer;
	
	@Inject
	ConfigDefaultService defSer;
	
	public void index(String groupId){
		List<ConfigGroup> groups = groupSer.selectAll();
		if(EStr.isEmpty(groupId)) groupId = groups.get(0).getId();
		setAttr("groupId", groupId);
		setAttr("groups", EJson.toJson(groups));
		render("defs.html");
	}
	
	public void getData(String groupId){
		List<ConfigDefault> defs = defSer.getByGroup(groupId);
		renderJson(Result.success("defs", defs));
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		ConfigDefault model = paras.getModel(ConfigDefault.class);
		defSer.saveOrUpdate(model);
		List<ConfigDefault> defs = defSer.getByGroup(model.getGroupId());
		renderJson(Result.success("defs", defs));
	}
	
	public void remove(String groupId, String id){
		defSer.disable(id);
		List<ConfigDefault> defs = defSer.getByGroup(groupId);
		renderJson(Result.success("defs", defs));
	}
	
	public void getCompsVal(String code){
		List<Record> recs = defSer.getCompsVal(code);
		renderJson(Result.success("recs", recs));
	}
	
	public void setCompsVal(String code, String doms, String val){
		if(val == null){
			defSer.cleanCompsVal(code, doms);
		}else{
			defSer.setCompsVal(code, doms, val);
		}
		List<Record> recs = defSer.getCompsVal(code);
		renderJson(Result.success("recs", recs));
	}
	
}
