package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.main.ModuleConfig;
import itez.plat.main.model.ConfigDefault;
import itez.plat.main.model.ConfigGroup;
import itez.plat.main.service.ConfigGroupService;
import itez.plat.main.service.ConfigService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Role(value = ModuleConfig.RoleHighAdmin)
@ControllerDefine(key = "/config/setting", summary = "系统参数设置", view = "/config")
public class ConfigController extends EControllerMgr {

	@Inject
	ConfigGroupService groupSer;
	
	@Inject
	ConfigService cfgSer;
	
	public void index(String groupId){
		List<ConfigGroup> groups = groupSer.getByComp();
		if(EStr.isEmpty(groupId)) groupId = groups.get(0).getId();
		setAttr("groupId", groupId);
		setAttr("groups", EJson.toJson(groups));
		render("values.html");
	}
	
	public void getData(String groupId){
		List<Record> cfgs = cfgSer.getByGroup(groupId);
		renderJson(Result.success("cfgs", cfgs));
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		ConfigDefault model = paras.getModel(ConfigDefault.class);
		cfgSer.setByCode(model.getCode(), model.getValue());
		List<Record> cfgs = cfgSer.getByGroup(model.getGroupId());
		renderJson(Result.success("cfgs", cfgs));
	}
	
}
