/**
 * CacheController.java
 */
package itez.plat.main.controller;

import itez.core.util.ECacheKit;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.wrapper.controller.EControllerSup;

/**
 * <p>
 * 缓存管理
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年8月27日 上午10:31:18
 */
@ControllerDefine(key = "/cache", summary = "缓存管理", view = "/")
public class CacheController extends EControllerSup {

	public void index(){
		render("cache.html");
	}
	
	/**
	 * <p>
	 * 返回缓存内容
	 * </p>
	 * 
	 * @param cache
	 * @param key
	 */
	public void getData(String cache, String key){
		Object val = ECacheKit.get(cache, key);
		String json = null == val ? null : EJson.format(EJson.toJson(val));
		renderJson(Result.success("val", json));
	}
	
	/**
	 * <p>
	 * 清除缓存
	 * </p>
	 * 
	 * @param cache
	 * @param key
	 */
	public void remove(String cache, String key){
		if(EStr.isEmpty(key)){
			ECacheKit.removeAll(cache);
		}else{
			ECacheKit.remove(cache, key);
		}
		renderJson(Result.success());
	}
	
}
