package itez.plat.main.controller;

import java.util.List;

import com.google.inject.Inject;
import com.jfinal.aop.Clear;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.plat.main.model.AppUpdate;
import itez.plat.main.service.AppUpdateService;
import itez.plat.wrapper.controller.EControllerMgr;

@ControllerDefine(key = "/app/update", summary = "客户端更新", view = "/app")
public class AppUpdateController extends EControllerMgr {
	
	@Inject
	AppUpdateService appSer;

	public void index(String appid, String os){
		if(EStr.isEmpty(os)) os = "android";
		List<AppUpdate> apps = appSer.getApps(appid, os);
		setAttr("appId", appid);
		setAttr("osType", os);
		setAttr("apps", EJson.toJson(apps));
		render("list.html");
	}
	
	public void form(String appid, String os, String id){
		if(EStr.isEmpty(os)) os = "android";
		AppUpdate app = EStr.isEmpty(id) ? new AppUpdate().setAppId(appid).setOsType(os): appSer.findById(id);
		setAttr("app", EJson.toJson(app));
		render("form.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		AppUpdate app = paras.getModel(AppUpdate.class);
		String url = paras.getFile("url");
		if(EStr.isEmpty(app.getId())){
			app.setUrl(url);
			appSer.save(app);
		}else{
			if(EStr.notEmpty(url)) app.setUrl(url);
			appSer.update(app);
		}
		redirect(attr().getCtrl().concat("?appid=").concat(app.getAppId()).concat("&os=").concat(app.getOsType()));
	}
	
	public void remove(String appid, String os, String id){
		appSer.deleteById(id);
		redirect(attr().getCtrl().concat("?appid=").concat(appid).concat("&os=").concat(os));
	}
	
	@Clear
	public void chk(String appid, String ver, String os){
		AppUpdate app = appSer.chk(appid, os, ver);
		ERet ret = null;
		if(app == null){
			ret = ERet.fail();
		}else{
			ret = ERet.ok("app", app);
		}
		renderJson(ret);
	}
	
}
