/**
 * RsaKeys.java
 */
package itez.kit.rsa;

import java.security.KeyPair;

/**
 * <p>
 * 公钥/私钥对
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年3月16日 上午11:36:45
 */
public class RsaKeys {

	private String publicKey;
	private String privateKey;
	
	public RsaKeys(KeyPair keyPair){
		publicKey = RsaKit.encryptBASE64(keyPair.getPublic().getEncoded());
		privateKey = RsaKit.encryptBASE64(keyPair.getPrivate().getEncoded());
	}

	public String getPublicKey() {
		return publicKey;
	}

	public String getPrivateKey() {
		return privateKey;
	}
	
}
