/**
 * ResultCode.java
 */
package itez.kit.restful;

/**
 * <p>
 * 全局状态码
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年4月22日 上午10:29:21
 */
public enum ResultCode {

	SUCCESS(200, "操作成功"),
	
	AUTH_LOGIN(301, "请先登录"),
	AUTH_PERM(302, "缺少权限"),
	AUTH_ROLE(303, "缺少角色"),
	AUTH_LICENSE(304, "缺少功能许可"),
	
	ERR_RUNTIME(400, "发生运行时错误"),
	ERR_BUSY(401, "系统繁忙，请稍后再试"),
	ERR_LOGIC(402, "发生业务逻辑错误"),
	
	PARAM_EMPTY(500, "缺少必要参数"),
	PARAM_INVALID(501, "参数不符合要求");

	private int code;
	private String desc;

	private ResultCode(int code, String desc) {
		this.code = code;
		this.desc = desc;
	}

	public int getCode() {
		return code;
	}

	public String getDesc() {
		return desc;
	}
	
}
