package itez.kit.poi;

import org.apache.poi.ss.usermodel.CellType;

public class XlsHeaderItem {
	
	private String code;
	private String caption;
	private CellType cellType = CellType.STRING;
	private String align = "left";
	private Object defValue = null;
	private boolean bold = false;
	
	public XlsHeaderItem(String code, String caption){
		this.code = code;
		this.caption = caption;
	}
	
	public static XlsHeaderItem create(String code, String caption){
		return new XlsHeaderItem(code, caption);
	}

	public CellType getCellType() {
		return cellType;
	}

	public XlsHeaderItem setCellType(CellType cellType) {
		this.cellType = cellType;
		return this;
	}

	public String getCode() {
		return code;
	}

	public String getCaption() {
		return caption;
	}

	public String getAlign() {
		return align;
	}

	public XlsHeaderItem setAlign(String align) {
		this.align = align;
		return this;
	}

	public boolean isBold() {
		return bold;
	}

	public XlsHeaderItem setBold(boolean bold) {
		this.bold = bold;
		return this;
	}

	public Object getDefValue() {
		return defValue;
	}

	public XlsHeaderItem setDefValue(Object defValue) {
		this.defValue = defValue;
		return this;
	}
	
}
