package itez.kit.poi;

import java.util.List;

import com.beust.jcommander.internal.Lists;

public class XlsHeader {

	private List<XlsHeaderItem> items;
	private boolean showCode = true;
	private boolean showCaption = true;
	
	public XlsHeader(List<XlsHeaderItem> items){
		if(items == null) items = Lists.newArrayList();
		this.items = items;
	}
	
	public static XlsHeader create(){
		return new XlsHeader(null);
	}
	
	public static XlsHeader create(List<XlsHeaderItem> items){
		return new XlsHeader(items);
	}

	public boolean getShowCaption() {
		return showCaption;
	}

	public XlsHeader setShowCaption(boolean showCaption) {
		this.showCaption = showCaption;
		return this;
	}

	public boolean getShowCode() {
		return showCode;
	}

	public XlsHeader setShowCode(boolean showCode) {
		this.showCode = showCode;
		return this;
	}

	public List<XlsHeaderItem> getItems() {
		return items;
	}

	public XlsHeader setItems(List<XlsHeaderItem> items) {
		this.items = items;
		return this;
	}
	
	public XlsHeader addItem(XlsHeaderItem item){
		this.items.add(item);
		return this;
	}
	
}
