package itez.kit.poi;

import java.util.List;

import com.google.common.collect.Lists;

public class ERow {

	private Integer index = 0;
	private List<ECell> cells = Lists.newArrayList();
	private boolean isHeader = false;
	
	public ECell getCell(Integer cellIndex){
		return cells.get(cellIndex);
	}
	public ERow putCell(ECell cell){
		this.cells.add(cell);
		return this;
	}
	public Integer getIndex() {
		return index;
	}
	public ERow setIndex(Integer index) {
		this.index = index;
		return this;
	}
	public List<ECell> getCells() {
		return cells;
	}
	public ERow setCells(List<ECell> cols) {
		this.cells = cols;
		return this;
	}
	public boolean isHeader() {
		return isHeader;
	}
	public ERow setHeader(boolean isHeader) {
		this.isHeader = isHeader;
		return this;
	}
	
}
