package itez.kit.pic;

import java.awt.image.BufferedImage;

import itez.kit.EProp;
import net.coobird.thumbnailator.Thumbnails;

public class EPicThumbnailator extends EPic {

	@Override
	public void compress(String srcPath, String destPath, Float quality) {
		try {
			Thumbnails.of(srcPath).scale(1f).outputQuality(quality).toFile(destPath);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public BufferedImage compress(String srcPath, Float quality) {
		try {
			return Thumbnails.of(srcPath).scale(1f).outputQuality(quality).asBufferedImage();
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public void compress(String srcPath, String destPath, Float quality, Float scale) {
		try {
			Thumbnails.of(srcPath).scale(scale).outputQuality(quality).toFile(destPath);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public BufferedImage compress(String srcPath, Float quality, Float scale) {
		try {
			return Thumbnails.of(srcPath).scale(scale).outputQuality(quality).asBufferedImage();
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public void compress(String srcPath, String destPath, Float quality, Integer width, Integer height) {
		try {
			Thumbnails.of(srcPath).size(width, height).outputQuality(quality).toFile(destPath);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public BufferedImage compress(String srcPath, Float quality, Integer width, Integer height) {
		try {
			return Thumbnails.of(srcPath).size(width, height).outputQuality(quality).asBufferedImage();
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public void compressFree(String srcPath, String destPath, Float quality, Integer width, Integer height) {
		try {
			Thumbnails.of(srcPath).size(width, height).keepAspectRatio(false).outputQuality(quality).toFile(destPath);
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}

	@Override
	public BufferedImage compressFree(String srcPath, Float quality, Integer width, Integer height) {
		try {
			return Thumbnails.of(srcPath).size(width, height).keepAspectRatio(false).outputQuality(quality).asBufferedImage();
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}

}
