package itez.kit.pic;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import itez.kit.EBase64;
import itez.kit.EStr;

public class EPicBase64 {

	/**
	 * 本地图片转换成base64字符串
	 * 
	 * @param imgFile 图片本地路径
	 * @return
	 */
	public static String localImageToBase64(String imgFile) {
		InputStream in = null;
		byte[] data = null;
		try {
			in = new FileInputStream(imgFile);
			data = new byte[in.available()];
			in.read(data);
			in.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EBase64.encode(data);
	}

	/**
	 * 在线图片转换成base64字符串
	 * 
	 * @param imgURL 图片线上路径
	 * @return
	 */
	public static String onlineImageToBase64(String imgURL) {
		ByteArrayOutputStream data = new ByteArrayOutputStream();
		try {
			URL url = new URL(imgURL);
			byte[] by = new byte[1024];
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("GET");
			conn.setConnectTimeout(5000);
			InputStream is = conn.getInputStream();
			int len = -1;
			while ((len = is.read(by)) != -1) {
				data.write(by, 0, len);
			}
			is.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EBase64.encode(data.toByteArray());
	}

	/**
	 * base64字符串转换成图片
	 * 
	 * @param imgStr base64字符串
	 * @param imgFilePath 图片存放路径
	 * @return
	 */
	public static boolean Base64ToImage(String imgStr, String imgFilePath) {
		if (EStr.isEmpty(imgStr)) return false;
		try {
			byte[] b = EBase64.decode2byte(imgStr);
			for (int i = 0; i < b.length; ++i) {
				if (b[i] < 0) b[i] += 256;
			}
			OutputStream out = new FileOutputStream(imgFilePath);
			out.write(b);
			out.flush();
			out.close();
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	public static void main(String[] args) throws Exception {
		// 本地图片地址
		//String url = "D:/tools/pictures/01.jpeg";
		//String str = EPicBase64.localImageToBase64(url);
		//System.out.println(str);
		//EPicBase64.Base64ToImage(str, "D:/tools/pictures/02.jpg");
		// 在线图片地址
		//String string = "https://bj.bcebos.com/v1/issue-luigi/%E7%99%BB%E9%99%86%E9%A1%B5%402x-20190702115544-mufvqd.png";
		//String ste = EPicBase64.onlineImageToBase64(string);
		//System.out.println(ste);
		//EPicBase64.Base64ToImage(ste, "D:/tools/pictures/02.png");
	}

}