/**
 * 
 */
package itez.kit.pay.wechat;

import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import itez.core.runtime.EContext;
import itez.kit.EFile;
import itez.kit.ELog;
import itez.kit.ENum;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.EWeb;
import itez.kit.pay.PayBase;
import itez.kit.pay.PayOver;
import itez.kit.restful.EMap;
import itez.tp.impl.weixin.payment.PaymentApi;
import itez.tp.impl.weixin.payment.PaymentApi.TradeType;
import itez.tp.impl.weixin.payment.utils.PaymentKit;

/**
 * <p>
 * 微信支付
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年8月4日 下午9:54:13
 */
public class PayWechat extends PayBase {

	public final static String KEY_APPID = "APPID";				//微信公众平台AppId
	public final static String KEY_MCHID = "MCHID";				//微信商户号
	public final static String KEY_APIKEY = "APIKEY";			//微信商户API密钥
	public final static String KEY_CALLBACK = "CALLBACK";		//回调地址
	public final static String KEY_BODY = "BODY";				//商品名称
	
	public final static String KEY_ORDERID = "ORDERID";			//订单号
	public final static String KEY_PAYMENT = "PAYMENT";			//付款金额
	public final static String KEY_REMARK1 = "REMARK1";			//备注1（30字符）
	public final static String KEY_REMARK2 = "REMARK2";			//备注2（30字符）
		
	@Override
	@SuppressWarnings("unchecked")
	public String getQrCode(JSONObject configs, String orderId, String payment, String remark1, String remark2) {
		String appId = configs.getString(KEY_APPID);
		String businessId = configs.getString(KEY_MCHID);
		String businessKey = configs.getString(KEY_APIKEY);
		String callBackUrl = configs.getString(KEY_CALLBACK);
		String body = configs.getString(KEY_BODY);
		
		String ip = EStr.ifEmpty(EWeb.getIpAddr(EContext.getRequest()), "127.0.0.1");
		
		//微信支付的金额单位是“分”
		Double pays = ENum.mul(Double.valueOf(payment), 100d);
		payment = pays.intValue() + "";

		EMap paras = EMap.create();
		paras.put("appid", appId); // 微信公众平台AppId
		paras.put("mch_id", businessId); // 微信商户ID
		paras.put("body", body); // 商品描述
		paras.put("product_id", orderId); // 商品ID（使用订单号代替）
		paras.put("out_trade_no", orderId); // 订单号
		paras.put("total_fee", payment); // 费用金额
		paras.put("spbill_create_ip", ip); // 客户端IP
		paras.put("trade_type", TradeType.NATIVE.name()); // 交易类型
		paras.put("nonce_str", System.currentTimeMillis() / 1000 + ""); // 随机数
		paras.put("notify_url", callBackUrl); // 支付完成后的回调地址，不允许带参数

		String sign = PaymentKit.createSign(paras, businessKey); // 使用以上参数集合及商户密钥生成签名
		paras.put("sign", sign);

		String xmlResult = PaymentApi.pushOrder(paras); // 调用统一支付接口
		Map<String, String> result = PaymentKit.xmlToMap(xmlResult); // 接口返回
		String return_code = result.get("return_code"); // 返回通信标识
		String return_msg = result.get("return_msg"); // 错误原因
		if (EStr.isEmpty(return_code) || !"SUCCESS".equals(return_code)) throw new RuntimeException(return_msg); // 通信失败
		String result_code = result.get("result_code"); // 返回业务结果
		String err_code_des = result.get("err_code_des"); // 业务错误描述
		if (EStr.isEmpty(result_code) || !"SUCCESS".equals(result_code)) throw new RuntimeException(err_code_des); // 支付失败
		//String prepay_id = result.get("prepay_id"); //预支付会话标识，用于后续接口调用中使用，该值有效期为2小时
		String code_url = result.get("code_url"); // 用于生成二维码，展示给用户进行扫码支付
		return code_url;
	}

	@Override
	@SuppressWarnings("unchecked")
	public PayOver callback(JSONObject configs, EPara paras) {		
		String xmlMsg = paras.getRawData();
		Map<String, String> params = PaymentKit.xmlToMap(xmlMsg);
		String result_code = params.get("result_code"); //业务结果 SUCCESS/FAIL
		String err_code_des = params.get("err_code_des"); //错误返回的信息描述
		String orderId = params.get("out_trade_no"); //商户订单号
		String money = params.get("total_fee"); //总金额
		
		//微信支付的金额单位是“分”
		Double pays = ENum.div(Double.valueOf(money), 100d);
		money = Double.toString(pays);

		ELog.info("微信缴费回调，订单号：{}，交易状态：{}，订单金额：{}", orderId, result_code, money);

		String businessKey = configs.getString(KEY_APIKEY);

		if (PaymentKit.verifyNotify(params, businessKey)) {
			if (("SUCCESS").equals(result_code)){
				EMap xml = EMap.by("return_code", "SUCCESS").set("return_msg", "OK");
				String render = PaymentKit.toXml(xml);
				return PayOver.ok().setOrderId(orderId).setMoney(money).setRender(render);
			}
		}
		return PayOver.fail(err_code_des);
	}

	@Override
	public String paramsConfig() {
		return EFile.readInJar("itez/kit/pay/wechat/paramConfig.json");
	}

}
