package itez.kit.pay.ccb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.HashKit;
import com.jfinal.kit.Kv;

import itez.kit.ECode;
import itez.kit.EFile;
import itez.kit.EHttp;
import itez.kit.EPara;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.pay.PayBase;
import itez.kit.pay.PayOver;

/**
 * 建行聚合支付接口
 * @author netwild
 *
 */
public class PayCCB extends PayBase {

	private final static String Url = "https://ibsbjstar.ccb.com.cn/CCBIS/ccbMain?CCB_IBSVersion=V6";
	
	public final static String KEY_MERCHANTID = "MERCHANTID";	//商户代码
	public final static String KEY_POSID = "POSID";				//商户柜台代码
	public final static String KEY_BRANCHID = "BRANCHID";		//分行代码
	public final static String KEY_PUB= "PUB";					//公钥
	public final static String KEY_VERSION= "CCB_IBSVersion";	//版本（V6）
	public final static String KEY_ORDERID = "ORDERID";			//订单号
	public final static String KEY_PAYMENT = "PAYMENT";			//付款金额
	public final static String KEY_CURCODE = "CURCODE";			//币种（01－人民币）
	public final static String KEY_TXCODE = "TXCODE";			//交易码（530550）
	public final static String KEY_RETURNTYPE = "RETURNTYPE";	//返回类型（2：聚合扫码页面，3：聚合扫码JSON串）
	public final static String KEY_TIMEOUT = "TIMEOUT";			//超时时间（YYYYMMDDHHMMSS 如：20120214143005，空值不超时）
	public final static String KEY_REMARK1 = "REMARK1";			//备注1（30字符）
	public final static String KEY_REMARK2 = "REMARK2";			//备注2（30字符）
	
	public final static String KEY_ACC_TYPE = "ACC_TYPE";		//账户类型（如果有返回值，则参与验签）
	public final static String KEY_SUCCESS = "SUCCESS";			//成功标志（成功－Y，失败－N）
	public final static String KEY_TYPE = "TYPE";				//接口类型（如果有返回值，则参与验签）
	public final static String KEY_REFERER = "REFERER";			//Referer信息（如果有返回值，则参与验签）
	public final static String KEY_CLIENTIP = "CLIENTIP";		//客户端IP（如果有返回值，则参与验签）
	public final static String KEY_ACCDATE = "ACCDATE";			//记账日期（如果有返回值，则参与验签）
	public final static String KEY_USRMSG = "USRMSG";			//支付账户信息（如果有返回值，则参与验签）
	public final static String KEY_USRINFO = "USRINFO";			//客户加密信息（如果有返回值，则参与验签）
	public final static String KEY_PAYTYPE = "PAYTYPE";			//支付方式（ALIPAY:支付宝，WEIXIN：微信，空：建行龙支付）（如果有返回值，则参与验签）
	public final static String KEY_SIGN = "SIGN";				//数字签名
	
	//校验（MD5：MERCHANTID,POSID,BRANCHID,ORDERID,PAYMENT,CURCODE,TXCODE,REMARK1,REMARK2,RETURNTYPE,TIMEOUT,PUB）
	//其中PUB为对应柜台的公钥后30位
	public final static String KEY_MAC = "MAC";					

	@SuppressWarnings("unchecked")
	private String getQrCode(Kv params) {
		if(params == null) error("无效参数");
		if(EStr.isEmpty(params.getStr(KEY_CURCODE))) params.set(KEY_CURCODE, "01");
		if(EStr.isEmpty(params.getStr(KEY_TXCODE))) params.set(KEY_TXCODE, "530550");
		if(EStr.isEmpty(params.getStr(KEY_RETURNTYPE))) params.set(KEY_RETURNTYPE, "3");
		if(EStr.isEmpty(params.getStr(KEY_ORDERID))) params.set(KEY_ORDERID, "");
		if(EStr.isEmpty(params.getStr(KEY_TIMEOUT))) params.set(KEY_TIMEOUT, "");
		
		String remark1 = params.getStr(KEY_REMARK1);
		//remark1 = EStr.notEmpty(remark1) ? EScape.escape(remark1) : "";
		params.set(KEY_REMARK1, remark1);
		String remark2 = params.getStr(KEY_REMARK2);
		//remark2 = EStr.notEmpty(remark2) ? EScape.escape(remark2) : "";
		params.set(KEY_REMARK2, remark2);

		//生成签名的参数
		StringBuilder macPara = new StringBuilder();
        macPara.append("MERCHANTID=");
        macPara.append(params.getStr(KEY_MERCHANTID));
        macPara.append("&POSID=");
        macPara.append(params.getStr(KEY_POSID));
        macPara.append("&BRANCHID=");
        macPara.append(params.getStr(KEY_BRANCHID));
        macPara.append("&ORDERID=");
        macPara.append(params.getStr(KEY_ORDERID));
        macPara.append("&PAYMENT=");
        macPara.append(params.getStr(KEY_PAYMENT));
        macPara.append("&CURCODE=");
        macPara.append(params.getStr(KEY_CURCODE));
        macPara.append("&TXCODE=");
        macPara.append(params.getStr(KEY_TXCODE));
        macPara.append("&REMARK1=");
        macPara.append(params.getStr(KEY_REMARK1));
        macPara.append("&REMARK2=");
        macPara.append(params.getStr(KEY_REMARK2));
        macPara.append("&RETURNTYPE=");
        macPara.append(params.getStr(KEY_RETURNTYPE));
        macPara.append("&TIMEOUT=");
        macPara.append(params.getStr(KEY_TIMEOUT));
        macPara.append("&PUB=");
        macPara.append(EStr.right(params.getStr(KEY_PUB), 30));
        String mac = HashKit.md5(macPara.toString());
        
        params.set(KEY_VERSION, "V6").set(KEY_MAC, mac).delete(KEY_PUB);
        
        String ret; JSONObject retObj;
        
        ret = EHttp.me.postForm(Url, params);
        if(EStr.isEmpty(ret)) error("获取支付信息（步骤1）时发生错误！");
        if(params.getStr(KEY_RETURNTYPE).equals("2")) return ret; //直接返回建行统一的二维码页面HTML
        
        retObj = JSON.parseObject(ret);
        String PAYURL = retObj.getString("PAYURL");
        
        ret = EHttp.me.get(PAYURL);
        if(EStr.isEmpty(ret)) error("获取支付信息（步骤2）时发生错误！");
        
        retObj = JSON.parseObject(ret);
        String QRURL = retObj.getString("QRURL");
        if(EStr.notEmpty(QRURL)) QRURL = ECode.URLDecode(QRURL);
        
        return QRURL;
	}

	@Override
	public String getQrCode(JSONObject configs, String orderId, String payment, String remark1, String remark2) {
		Kv kv = Kv.create();
		kv.set(KEY_MERCHANTID, configs.getString(KEY_MERCHANTID));
		kv.set(KEY_POSID, configs.getString(KEY_POSID));
		kv.set(KEY_BRANCHID, configs.getString(KEY_BRANCHID));
		kv.set(KEY_PUB, configs.getString(KEY_PUB)); //密钥

		kv.set(KEY_ORDERID, orderId);
		kv.set(KEY_PAYMENT, payment);
		kv.set(KEY_REMARK1, remark1);
		kv.set(KEY_REMARK2, remark2);
		return getQrCode(kv);
	}

	/**
	 * 支付完成后的回调
	 * 
	 * @param paras request参数封装
	 */
	@Override
	public PayOver callback(JSONObject configs, EPara paras) {
		ERet ret = ERet.create();
		ret.set(KEY_POSID, paras.get(KEY_POSID, ""));
		ret.set(KEY_BRANCHID, paras.get(KEY_BRANCHID, ""));
		ret.set(KEY_ORDERID, paras.get(KEY_ORDERID, ""));
		ret.set(KEY_PAYMENT, paras.get(KEY_PAYMENT, ""));
		ret.set(KEY_CURCODE, paras.get(KEY_CURCODE, ""));
		ret.set(KEY_REMARK1, paras.get(KEY_REMARK1, ""));
		ret.set(KEY_REMARK2, paras.get(KEY_REMARK2, ""));
		ret.set(KEY_ACC_TYPE, paras.get(KEY_ACC_TYPE, ""));
		ret.set(KEY_SUCCESS, paras.get(KEY_SUCCESS, ""));
		ret.set(KEY_TYPE, paras.get(KEY_TYPE));
		ret.set(KEY_REFERER, paras.get(KEY_REFERER));
		ret.set(KEY_CLIENTIP, paras.get(KEY_CLIENTIP));
		ret.set(KEY_ACCDATE, paras.get(KEY_ACCDATE));
		ret.set(KEY_USRMSG, paras.get(KEY_USRMSG));
		ret.set(KEY_USRINFO, paras.get(KEY_USRINFO));
		ret.set(KEY_PAYTYPE, paras.get(KEY_PAYTYPE));
		ret.set(KEY_SIGN, paras.get(KEY_SIGN));
		
		if(!ret.getStr(KEY_SUCCESS).equals("Y")) return PayOver.fail("支付失败");

		/**
		 * 整理参与验签的原始参数串
		 */
		StringBuilder macPara = new StringBuilder();
        macPara.append("POSID=");
        macPara.append(ret.getStr(KEY_POSID));
        macPara.append("&BRANCHID=");
        macPara.append(ret.getStr(KEY_BRANCHID));
        macPara.append("&ORDERID=");
        macPara.append(ret.getStr(KEY_ORDERID));
        macPara.append("&PAYMENT=");
        macPara.append(ret.getStr(KEY_PAYMENT));
        macPara.append("&CURCODE=");
        macPara.append(ret.getStr(KEY_CURCODE));
        macPara.append("&REMARK1=");
        macPara.append(ret.getStr(KEY_REMARK1));
        macPara.append("&REMARK2=");
        macPara.append(ret.getStr(KEY_REMARK2));
        macPara.append("&ACC_TYPE=");
        macPara.append(ret.getStr(KEY_ACC_TYPE));
        macPara.append("&SUCCESS=");
        macPara.append(ret.getStr(KEY_SUCCESS));
        
        if(EStr.notNull(ret.get(KEY_TYPE))){
            macPara.append("&TYPE=");
            macPara.append(ret.getStr(KEY_TYPE));
        }
        if(EStr.notNull(ret.get(KEY_REFERER))){
            macPara.append("&REFERER=");
            macPara.append(ret.getStr(KEY_REFERER));
        }
        if(EStr.notNull(ret.get(KEY_CLIENTIP))){
            macPara.append("&CLIENTIP=");
            macPara.append(ret.getStr(KEY_CLIENTIP));
        }
        if(EStr.notNull(ret.get(KEY_ACCDATE))){
            macPara.append("&ACCDATE=");
            macPara.append(ret.getStr(KEY_ACCDATE));
        }
        if(EStr.notNull(ret.get(KEY_USRMSG))){
            macPara.append("&USRMSG=");
            macPara.append(ret.getStr(KEY_USRMSG));
        }
        if(EStr.notNull(ret.get(KEY_USRINFO))){
            macPara.append("&USRINFO=");
            macPara.append(ret.getStr(KEY_USRINFO));
        }
        if(EStr.notNull(ret.get(KEY_PAYTYPE))){
            macPara.append("&PAYTYPE=");
            macPara.append(ret.getStr(KEY_PAYTYPE));
        }
        
        String macStr = macPara.toString();

        
        /**
         * 获取公钥，此处使用完整公钥串，非后30位
         */
        String pub = configs.getString(KEY_PUB);
        if(EStr.isEmpty(pub)) error("未接收到有效的密钥：request.attr('" + KEY_PUB + "')");
        
        /**
         * 获取签名
         */
        String sign = ret.getStr(KEY_SIGN);
        
		RSASig rsa = new RSASig();
		rsa.setPublicKey(pub);
		boolean vali = rsa.verifySigature(sign, macStr);
		
		if(!vali){
			return PayOver.fail("验签失败");
		} else {
			String orderId = ret.getStr(KEY_ORDERID);
			String money = ret.getStr(KEY_PAYMENT);
			return PayOver.ok().setOrderId(orderId).setMoney(money).setRender("");
		}
	}
	
	private void error(String msg){
		throw new RuntimeException(msg);
	}

	@Override
	public String paramsConfig() {
		return EFile.readInJar("itez/kit/pay/ccb/paramConfig.json");
	}
	
}
