/**
 * 
 */
package itez.kit.pay.alipay;

import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradePrecreateModel;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayTradePrecreateRequest;
import com.alipay.api.response.AlipayTradePrecreateResponse;
import com.beust.jcommander.internal.Maps;

import itez.kit.EFile;
import itez.kit.ELog;
import itez.kit.EPara;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.log.ExceptionUtil;
import itez.kit.pay.PayBase;
import itez.kit.pay.PayOver;
import itez.kit.restful.EMap;

/**
 * <p>
 * 支付宝
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年8月4日 下午9:54:13
 * 
 * https://opendocs.alipay.com/open/194/106078
 * 
 */
public class PayAli extends PayBase {

	public final static String KEY_APPID = "APP_ID";					//支付宝应用ID
	public final static String KEY_PRIVATE_KEY = "APP_PRIVATE_KEY";		//应用私钥
	public final static String KEY_PUBLIC_KEY = "ALIPAY_PUBLIC_KEY";	//支付宝公钥
	public final static String KEY_CALLBACK = "CALLBACK";				//回调地址
	public final static String KEY_BODY = "BODY";						//商品名称
	
	public final static String KEY_ORDERID = "ORDERID";			//订单号
	public final static String KEY_PAYMENT = "PAYMENT";			//付款金额
	public final static String KEY_REMARK1 = "REMARK1";			//备注1（30字符）
	public final static String KEY_REMARK2 = "REMARK2";			//备注2（30字符）
	
	private Map<String, AlipayClient> clients = Maps.newHashMap();
		
	@Override
	public String getQrCode(JSONObject configs, String orderId, String payment, String remark1, String remark2) {
		String callBackUrl = configs.getString(KEY_CALLBACK);	//回调地址
		String body = configs.getString(KEY_BODY);				//商品名称

		AlipayClient client = getClient(configs);
		AlipayTradePrecreateModel model = new AlipayTradePrecreateModel();
		model.setOutTradeNo(orderId);		//商户订单号
		model.setTotalAmount(payment);		//金额
		model.setSubject(body);				//商品名称
		model.setTimeoutExpress("90m");		//订单有效时长（m分钟，h小时）
		
		AlipayTradePrecreateRequest request = new AlipayTradePrecreateRequest();
		request.setNotifyUrl(callBackUrl);
		request.setBizModel(model);
		
		String qr_code = null;
		try {
			AlipayTradePrecreateResponse response = client.execute(request);
			String code = response.getCode();
			String msg = response.getMsg();
			if (EStr.isEmpty(code) || !"10000".equals(code)) throw new RuntimeException(msg);
			qr_code = response.getQrCode();
		} catch (AlipayApiException e) {
			if(EProp.DevMode) e.printStackTrace();
			error(e.getMessage());
		}
		return qr_code;
	}

	@Override
	@SuppressWarnings("unchecked")
	public PayOver callback(JSONObject configs, EPara paras) {
		String trade_status = paras.get("trade_status");		//交易状态（TRADE_SUCCESS、TRADE_FINISHED）
		String money = paras.get("total_amount");				//订单金额
		String out_trade_no = paras.get("out_trade_no");		//商户订单号
		String sign = paras.get("sign");						//签名
		String signType = "RSA2";								//签名类型（ RSA2 和 RSA）
		
		ELog.info("支付宝缴费回调，订单号：{}，交易状态：{}，订单金额：{}", out_trade_no, trade_status, money);
		
		boolean chk = false;
		//ELog.info("Sign1: {}", sign);
		if(EStr.isEmpty(sign)) return PayOver.fail("验签失败，未发现签名");
		if(!trade_status.equals("TRADE_SUCCESS")) return PayOver.fail("验签失败，订单状态无效（" + trade_status + "）");
		try {
			String ALIPAY_PUBLIC_KEY = configs.getString(KEY_PUBLIC_KEY);
			EMap params = paras.getParas();
			//ELog.info("Sign2: {}", params.getStr("sign"));
			chk = AlipaySignature.rsaCheckV1(params, ALIPAY_PUBLIC_KEY, EStr.Encoding, signType);
		} catch (AlipayApiException e) {
			if(EProp.DevMode) e.printStackTrace();
			ELog.error(ExceptionUtil.getMessage(e));
		}
		if (chk) {
			return PayOver.ok().setOrderId(out_trade_no).setMoney(money).setRender("success");
		}else{
			return PayOver.fail("验签失败");
		}
	}

	@Override
	public String paramsConfig() {
		return EFile.readInJar("itez/kit/pay/alipay/paramConfig.json");
	}
	
	private AlipayClient getClient(JSONObject configs){
		String APP_ID = configs.getString(KEY_APPID);
		AlipayClient client = clients.get(APP_ID);
		if(client == null){
			String SERVER_URL = "https://openapi.alipay.com/gateway.do";//"https://openapi.alipaydev.com/gateway.do";
			String APP_PRIVATE_KEY = configs.getString(KEY_PRIVATE_KEY);
			String ALIPAY_PUBLIC_KEY = configs.getString(KEY_PUBLIC_KEY);
			String FORMAT = "json";
			String CHARSET = EStr.Encoding;
			String SIGN_TYPE = "RSA2";
			client = new DefaultAlipayClient(SERVER_URL, APP_ID, APP_PRIVATE_KEY, FORMAT, CHARSET, ALIPAY_PUBLIC_KEY, SIGN_TYPE);
			clients.put(APP_ID, client);
		}
		return client;
	}
	
	private void error(String msg){
		throw new RuntimeException(msg);
	}

}
