/**
 * PayOver.java
 */
package itez.kit.pay;

import itez.kit.restful.EMap;

/**
 * <p>
 * 类描述
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年8月12日 上午9:09:22
 */
public class PayOver {

	private boolean state = false;
	private String msg = "";
	private String orderId = "";
	private String money = "";
	private String render = "";
	private EMap data = EMap.create();
	
	private PayOver(){}
	
	public static PayOver ok(){
		return new PayOver().setState(true);
	}
	
	public static PayOver fail(String msg){
		return new PayOver().setState(false).setMsg(msg);
	}

	public boolean getState() {
		return state;
	}

	public PayOver setState(boolean state) {
		this.state = state;
		return this;
	}

	public String getMsg() {
		return msg;
	}

	public PayOver setMsg(String msg) {
		this.msg = msg;
		return this;
	}

	public String getOrderId() {
		return orderId;
	}

	public PayOver setOrderId(String orderId) {
		this.orderId = orderId;
		return this;
	}

	public String getMoney() {
		return money;
	}

	public PayOver setMoney(String money) {
		this.money = money;
		return this;
	}

	public String getRender() {
		return render;
	}

	public PayOver setRender(String render) {
		this.render = render;
		return this;
	}

	public EMap getData() {
		return data;
	}

	public PayOver setData(EMap data) {
		this.data = data;
		return this;
	}
	
	public PayOver set(String key, String val){
		this.data.set(key, val);
		return this;
	}
	
	public String get(String key){
		return this.data.getStr(key);
	}
	
}
