package itez.kit.log;

public class ELogImpl extends ELogBase {

	private org.slf4j.Logger log;
	
	public ELogImpl(Class<?> clazz) {
		log = org.slf4j.LoggerFactory.getLogger(clazz);
	}

	public ELogImpl(String clazz) {
		log = org.slf4j.LoggerFactory.getLogger(clazz);
	}

	@Override
	public void debug(String message, Object... args) {
		log.debug(message, args);
	}

	@Override
	public void info(String message, Object... args) {
		log.info(message, args);
	}

	@Override
	public void warn(String message, Object... args) {
		log.warn(message, args);
	}

	@Override
	public void error(String message, Object... args) {
		log.error(message, args);
	}

	@Override
	public void debug(String message) {
		log.debug(message);
	}

	@Override
	public void debug(String message, Throwable t) {
		log.debug(message, t);
	}

	@Override
	public void info(String message) {
		log.info(message);
	}

	@Override
	public void info(String message, Throwable t) {
		log.info(message, t);
	}

	@Override
	public void warn(String message) {
		log.warn(message);
	}

	@Override
	public void warn(String message, Throwable t) {
		log.warn(message, t);
	}

	@Override
	public void error(String message) {
		log.error(message);
	}

	@Override
	public void error(String message, Throwable t) {
		log.error(message, t);
	}

	@Override
	public void fatal(String message) {
		log.error(message);
	}

	@Override
	public void fatal(String message, Throwable t) {
		log.error(message, t);
	}

	@Override
	public boolean isDebugEnabled() {
		return true;
	}

	@Override
	public boolean isInfoEnabled() {
		return true;
	}

	@Override
	public boolean isWarnEnabled() {
		return true;
	}

	@Override
	public boolean isErrorEnabled() {
		return true;
	}

	@Override
	public boolean isFatalEnabled() {
		return false;
	}

}
