package itez.kit.json;

import itez.kit.EStr;

/**
 * 该类提供格式化JSON字符串的方法。 该类的方法formatJson将JSON字符串格式化，方便查看JSON数据
 */
public class EJsonFomat {

	/**
	 * 格式化JSON字符串。
	 * 
	 * @param json 未格式化的JSON字符串。
	 * @return 格式化的JSON字符串。
	 */
	public static String format(String json) {
		return format(json, 0);
	}
	
	public static String format(String json, int tab){
		if(EStr.isEmpty(json)) return json;
		json = json.replaceAll("(\\r|\\n|\\t)", "");
		StringBuffer ret = new StringBuffer();
		int len = json.length();
		char curr = 0, next = 0;
		boolean inMode = false, openMode = false;
		for (int i = 0; i < len; i++) {
			curr = json.charAt(i);
			next = (i < len - 1) ? json.charAt(i + 1) : 0;
			if(curr == '"') inMode = !inMode;
			if(curr == '(') openMode = true;
			else if(curr == ')') openMode = false;
			if(inMode){
				ret.append(curr);
			}else{
				if ((curr == '[') || (curr == '{')){
					ret.append(curr);
					ret.append('\n');
					tab++;
					ret.append(indent(tab));
				}else if ((curr == ']') || (curr == '}')){
					ret.append('\n');
					tab--;
					ret.append(indent(tab));
					ret.append(curr);
				}else if ((curr == ':')) {
					ret.append(curr);
					if(next != ' ') ret.append(' ');
				}else if ((curr == ',')){
					ret.append(curr);
					if (next == '{' || openMode){
						if(next != ' ') ret.append(' ');
					}else{
						ret.append('\n');
						ret.append(indent(tab));
					}
				}else{
					ret.append(curr);
				}
			}
		}
		return ret.toString();
	}

	/**
	 * 压缩JSON字符串。
	 * 
	 * @param json 格式化的JSON字符串。
	 * @return 压缩后的JSON字符串。
	 */
	public static String compress(String json) {
		if(EStr.isEmpty(json)) return json;
		return json.replaceAll("\\s*|\\t|\\r|\\n", "").replace("\\n", "");
	}

	/**
	 * 返回指定次数的缩进字符串
	 * @param number 缩进次数。
	 * @return 指定缩进次数的字符串。
	 */
	private static String indent(int tabCount) {
		StringBuffer tabs = new StringBuffer();
		for(int i=0; i<tabCount; i++) tabs.append("\t");
		return tabs.toString();
	}
}
