package itez.kit.ip2region;

import com.jfinal.kit.PathKit;

import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.ip2region.driver.Searcher;
import itez.kit.log.ELogBase;

public abstract class IP2RegionUtil {

	private static Searcher searcher = null;
	private static boolean complete = false;
	private static boolean success = false;
	
	private static final ELogBase log = ELog.log(IP2RegionUtil.class);
	
	private synchronized static void initSearcher(){
		if(complete) return;
		String dbPath = PathKit.getWebRootPath().concat("/localdb/ip2region/ip2region.xdb");
		try {
			byte[] cBuff = Searcher.loadContentFromFile(dbPath);
			searcher = Searcher.newWithBuffer(cBuff);
			success = true;
        } catch (Exception e) {
        	if(EProp.DevMode) e.printStackTrace();
        	else log.error("创建Searcher失败: ", e);
        } finally {
    		complete = true;
		}
	}
	
	public static String getRegion(String ip){
		String region = null;
		if(!complete) initSearcher();
		if(!success) return region;
		try {
			//long sTime = System.nanoTime();
			region = searcher.search(ip);
			//long eTime = System.nanoTime();
			//long cost = TimeUnit.NANOSECONDS.toMicros((long) eTime - sTime);
			//log.info("region: {}, ioCount: {}, took: {} μs", region, searcher.getIOCount(), cost);
		} catch (Exception e) {
        	if(EProp.DevMode) e.printStackTrace();
        	else log.error("搜索IP定位失败: ", e);
		}
		return region;
	}
	
}
