package itez.kit.html2image;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JEditorPane;

class H2ISwing extends H2IBase {

	private final String TYPE = "text/html;charset=utf-8";
	
	@Override
	public BufferedImage generator(String template, int width, int height) {
		JEditorPane pane = new JEditorPane(TYPE, template);
		pane.setEditable(false);
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
        Graphics graphics = image.getGraphics();
		pane.setSize(width, height);
        pane.paint(graphics);
        graphics.dispose();
		return image;
	}

}
