package itez.kit.html2image;

import java.util.Map;
import com.google.common.collect.Maps;

public class H2IKit {

	public static enum H2IEngine { SWING, Hlml2Image }
	
	public static final H2IEngine DEF_ENGINE = H2IEngine.Hlml2Image;
	private static Map<H2IEngine, H2IBase> engineMap = Maps.newHashMap();
		
	public static H2IBase use(){
		return use(DEF_ENGINE);
	}
	
	public static H2IBase use(H2IEngine eng){
		H2IBase h2i = engineMap.get(eng);
		if(h2i != null) return h2i;
		
		if(eng == H2IEngine.SWING) h2i = new H2ISwing();
		else h2i = new H2Image();
		
		engineMap.put(eng, h2i);
		return h2i;
	}
	
}
