package itez.kit.fileup;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;

import javax.imageio.ImageIO;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.Ret;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.BucketManager.FileListIterator;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;

import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.ERegex;
import itez.kit.EStr;
import itez.kit.EUid;

public class QiNiuImpl implements IFileUp {
	
	private String TempPath; //临时目录硬盘位置
	private static final String FileSep = File.separator;

	private String Url; //云盘域名
	private String AK; //云盘的AK
	private String SK; //云盘的SK
	private String Bucket; //存储桶别名，例如：mybucket
	private String BZone; //存储区域名称，例如：华北。为空时自动检索存储桶所在区域

	public QiNiuImpl(){
		AK = EProp.QiNiuStoreAK;
		SK = EProp.QiNiuStoreSK;
		Bucket = EProp.QiNiuStoreBucket;
		BZone = EProp.QiNiuStoreZone;
		Url = EProp.QiNiuStoreUrl;
		
        if(!Url.endsWith("/")){
        	Url += "/";
        }

		TempPath = EProp.FileUploadTemp;
		TempPath = formatPath(TempPath);
    	if(!TempPath.startsWith("/") && !TempPath.startsWith("\\") && !ERegex.has(TempPath, "^[A-Za-z]\\:")){
    		TempPath = PathKit.getWebRootPath() + FileSep + TempPath;
    	}
		if(!TempPath.endsWith(FileSep)){
			TempPath += FileSep;
		}
	}
	
	/**
	 * 七牛的机房区域
	 * @author netwild
	 *
	 */
	private enum StoreZone {
		EastChina("华东"), NorthChina("华北"), SouthChina("华南"), NorthAmerica("北美"), Auto("");
		private String desc;
		private Zone zone;
		private StoreZone(String desc){
	        this.desc = desc;
	        if(this.desc.equals("华东")) this.zone = Zone.zone0();
	        else if(this.desc.equals("华北")) this.zone = Zone.zone1();
	        else if(this.desc.equals("华南")) this.zone = Zone.zone2();
	        else if(this.desc.equals("北美")) this.zone = Zone.zoneNa0();
	        else this.zone = Zone.autoZone();
	    }
		public static StoreZone find(String desc){
	        if(desc.equals("华东")) return StoreZone.EastChina;
	        else if(desc.equals("华北")) return StoreZone.NorthChina;
	        else if(desc.equals("华南")) return StoreZone.SouthChina;
	        else if(desc.equals("北美")) return StoreZone.NorthAmerica;
	        else return StoreZone.Auto;
		}
	}
	
	@Override
	public String upload(BufferedImage file, String formatName, String subPath) {
		return upload(file, formatName, subPath, true);
	}
	
	@Override
	public String upload(BufferedImage file, String formatName, String subPath, boolean uuidName) {
		File f = new File(TempPath.concat("thu.jpg"));
		if(EStr.isEmpty(formatName)) formatName = "jpg";
		try {
			ImageIO.write(file, formatName, f);
			return upload(f, subPath, uuidName);
		} catch (Exception e) {
			return null;
		}
	}
	
	@Override
	public String upload(File file, String subPath) {
		return upload(file, subPath, true);
	}
	
	@Override
	public String upload(File file, String subPath, boolean uuidName) {
		String FileSep = "/";
		String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
		String fileName = file.getName();
		String extName = fileName.substring(fileName.lastIndexOf("."));
		if(EStr.notEmpty(subPath)){
			if(subPath.startsWith(FileSep)) subPath = subPath.substring(1);
			if(!subPath.endsWith(FileSep)) subPath += FileSep;
		}
		String key;
		if(uuidName){
			key = String.format("%s%s%s%s", subPath, fileIndex, EUid.generator(), extName);
		}else{
			key = String.format("%s%s", subPath, fileName);
		}
	    Configuration cfg = new Configuration(StoreZone.find(BZone).zone);
	    UploadManager uploadManager = new UploadManager(cfg);
	    Auth auth = Auth.create(AK, SK);
	    String upToken = auth.uploadToken(Bucket);
	    try {
	        Response response = uploadManager.put(file, key, upToken);
	        String retJson = response.bodyString();
	        Ret ret = JSON.parseObject(retJson, Ret.class);
	        file.delete();
	        return Url + ret.getStr("key");
	    } catch (QiniuException ex) {
	        Response r = ex.response;
	        System.err.println(r.toString());
	        try {
	            System.err.println(r.bodyString());
	        } catch (QiniuException ex2) {
	            //ignore
	        }
	    } catch(Exception ex){
	    	ex.printStackTrace();
	    }
		return null;
	}

	@Override
	public List<FileItem> list(String subPath) {
		List<FileItem> temps = Lists.newArrayList();
		Configuration cfg = new Configuration(StoreZone.find(BZone).zone);
		Auth auth = Auth.create(AK, SK);
		BucketManager bucketManager = new BucketManager(auth, cfg);
		String prefix = subPath; //文件名前缀
		int limit = 1000; //每次迭代的长度限制，最大1000，推荐值 1000
		String delimiter = ""; //指定目录分隔符，列出所有公共前缀（模拟列出目录效果）。缺省值为空字符串
		FileListIterator fileListIterator = bucketManager.createFileListIterator(Bucket, prefix, limit, delimiter);
		while (fileListIterator.hasNext()) {
		    FileInfo[] items = fileListIterator.next();
		    for (FileInfo item : items) {
				FileItem temp = new FileItem();
				temp.setFileName(item.key.substring(item.key.lastIndexOf("/") + 1));
				temp.setFilePath(item.key);
				temp.setFileSize(item.fsize);
				temp.setMimeType(item.mimeType);
				temp.setUrl(Url + item.key);
				temps.add(temp);
				/*
		        System.out.println(item.key);
		        System.out.println(item.hash);
		        System.out.println(item.fsize);
		        System.out.println(item.mimeType);
		        System.out.println(item.putTime);
		        System.out.println(item.endUser);
		        */
		    }
		}
		return temps;
	}

	@Override
	public List<FileItem> list(String subPath, boolean directory) {
		return list(subPath);
	}

	@Override
	public boolean remove(String fileName) {
		Configuration cfg = new Configuration(StoreZone.find(BZone).zone);
		Auth auth = Auth.create(AK, SK);
		BucketManager bucketManager = new BucketManager(auth, cfg);
		try {
			bucketManager.delete(Bucket, fileName);
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	@Override
	public boolean createFolder(String subPath) {
		throw new RuntimeException("七牛云暂未实现创建目录！");
	}

	@Override
	public File getFile(String filePath) {
		throw new RuntimeException("七牛云暂未实现获取文件内容！");
	}

	@Override
	public String getFileStoreUrl() {
		return EProp.QiNiuStoreUrl;
	}
	
	private String formatPath(String path){
		return path.replace("/", FileSep).replace("\\", FileSep);
	}
	
	public static void main(String[] args) {
		QiNiuImpl fileio = new QiNiuImpl();
		File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
		String path = fileio.upload(file, "");
		System.out.println(path);
	}

}
