package itez.kit.fileup;

import java.io.File;
import java.util.Date;

import itez.kit.EFile;
import itez.kit.EStr;

public class FileItem {

	private File file;
	private boolean directory;
	private String fileName;
	private String filePath;
	private long fileSize;
	private String mimeType;
	private Date lastModified;
	private String content;
	private String url;
	
	public FileItem(){
		file = null;
		directory = false;
		fileName = null;
		filePath = null;
		fileSize = 0;
		lastModified = null;
		mimeType = null;
	}
	
	public FileItem(File file){
		this.file = file;
		directory = file.isDirectory();
		fileName = file.getName();
		filePath = file.getAbsolutePath();
		fileSize = file.length();
		lastModified = new Date(file.lastModified());
		mimeType = getExtName();
	}
	
	public FileItem loadContent(){
		if(null != file) content = EFile.read(file);
		return this;
	}
	
	public String getFileName() {
		return fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	public String getMimeType() {
		return mimeType;
	}
	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}
	public Date getLastModified() {
		return lastModified;
	}
	public void setLastModified(Date lastModified) {
		this.lastModified = lastModified;
	}
	public String getExtName(){
		if(EStr.isEmpty(fileName)) return "";
		return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
	}
	public String getFilePath() {
		return filePath;
	}
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public boolean isDirectory() {
		return directory;
	}
	public void setDirectory(boolean directory) {
		this.directory = directory;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public long getFileSize() {
		return fileSize;
	}
	public void setFileSize(long fileSize) {
		this.fileSize = fileSize;
	}
	public String getFileSizeEm() {
		int x = 1024 * 1024;
		String spaceStr;
		if(fileSize < 1024){
			spaceStr = String.format("%s %s", fileSize, "Byte");
		}else if(fileSize < x){
			spaceStr = String.format("%s %s", fileSize / 1024, "KB");
		}else{
			spaceStr = String.format("%s %s", fileSize / x, "MB");
		}
		return spaceStr;
	}
	
}
