package itez.kit.fileup;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;

public class EFileKit {

	public static boolean createFolder(String subPath){
		return EFileFactory.me.getFileIO().createFolder(subPath);
	}
	
	public static String upload(File file, String subPath) {
		return EFileFactory.me.getFileIO().upload(file, subPath);
	}
	
	public static String upload(BufferedImage file, String formatName, String subPath) {
		return EFileFactory.me.getFileIO().upload(file, formatName, subPath);
	}

	public static String upload(File file, String subPath, boolean uuidName) {
		return EFileFactory.me.getFileIO().upload(file, subPath, uuidName);
	}

	public static String upload(BufferedImage file, String formatName, String subPath, boolean uuidName) {
		return EFileFactory.me.getFileIO().upload(file, formatName, subPath, uuidName);
	}
	
	public static List<FileItem> list(String subPath){
		return EFileFactory.me.getFileIO().list(subPath);
	}
	
	public static List<FileItem> list(String subPath, boolean directory){
		return EFileFactory.me.getFileIO().list(subPath, directory);
	}
	
	public static boolean remove(String fileName){
		return EFileFactory.me.getFileIO().remove(fileName);
	}
	
	public static File getFile(String filePath){
		return EFileFactory.me.getFileIO().getFile(filePath);
	}
	
	public static String getFileStoreUrl(){
		return EFileFactory.me.getFileIO().getFileStoreUrl();
	}

	public static List<FileItem> localList(String root, String Url, String sub, boolean directory){
		return LocalImpl.localList(root, Url, sub, directory);
	}
	
	public static File localFile(String filePath){
		return LocalImpl.localFile(filePath);
	}

}
