package itez.kit.fileup;

import itez.core.runtime.EContext;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.log.ELogBase;

public final class EFileFactory {

	private static final ELogBase log = ELog.log(EFileFactory.class);
	public final static EFileFactory me = new EFileFactory();
	private IFileUp io = null;
	private IFileUp local = null;
	
	private EFileFactory(){
		this.local = new LocalImpl();
	}
	
	public void setFileIO(IFileUp io){
		this.io = io;
	}
	
	public IFileUp getFileIO(){
		if(null == this.io){
			String fileStorePlan = EProp.FileStorePlan.toLowerCase();
			log.info("文件上传方案：{}", fileStorePlan);
			if(fileStorePlan.equals("qiniu")){
				this.io = new QiNiuImpl();
			}else if(fileStorePlan.equals("tencent")){
				this.io = new TencentImpl();
			}else{
				this.io = this.local;
			}
		}
		return this.io;
	}
	
	public String getLocalDiskPath(){
		return ((LocalImpl)this.local).getDiskPath();
	}
	
	public String getLocalTempPath(){
		return ((LocalImpl)this.local).getTempPath();
	}
	
	public String getLocalUrl(){
		return ((LocalImpl)this.local).getUrl();
	}
	
	public String getLocalDomainPath(){
		String root = getLocalDiskPath();
		String domain = EContext.getAttr().getDomain();
		return root.concat(domain);
	}
	
	public String getLocalModulePath(){
		String root = getLocalDomainPath();
		String module = EContext.getAttr().getModuleCode();
		return String.join(EStr.FileSep, root, module);
	}
	
	public LocalImpl getLocalFile(){
		return (LocalImpl)this.local;
	}
	
}
