package itez.kit.eval;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import com.beust.jcommander.internal.Maps;
import com.google.common.collect.Lists;

import itez.kit.EJson;

public class NashornImpl extends BaseEngine implements IEngine {
	
	private final ScriptEngineManager scriptManager;
	private final ScriptEngine scriptEngine;
	private final Map<String, CompiledScript> scriptCompils = Maps.newHashMap();
	
	private final Class<?> MirrorCls;
	private final Method isEmptyMethod;
	private final Method isArrayMethod;
	private final Method sizeMethod;
	private final Method getOwnKeysMethod;
	private final Method getMethod;
	
	public NashornImpl(){
		try {
			scriptManager = new ScriptEngineManager();
			scriptEngine = scriptManager.getEngineByExtension("js");
			MirrorCls = Class.forName("jdk.nashorn.api.scripting.ScriptObjectMirror");
			isEmptyMethod = MirrorCls.getMethod("isEmpty");
			isArrayMethod = MirrorCls.getMethod("isArray");
			sizeMethod = MirrorCls.getMethod("size");
			getOwnKeysMethod = MirrorCls.getMethod("getOwnKeys", boolean.class);
			getMethod = MirrorCls.getMethod("get", Object.class);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T eval(String script) {
		try {
			Object ret = scriptEngine.eval(script);
			return null == ret ? null : (T) parseNativeObject(ret);
		} catch (Exception e) {
			throw new RuntimeException("执行脚本失败：" + e.getMessage());
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T eval(String script, Map<?, ?> params) {
		try {
			Object ret = scriptEngine.eval(script, bind(params));
			return null == ret ? null : (T) parseNativeObject(ret);
		} catch (Exception e) {
			throw new RuntimeException("执行脚本失败：" + e.getMessage());
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T evalCompile(String code) {
		if(!scriptCompils.containsKey(code)) throw new RuntimeException("请先编译脚本。");
		try {
			CompiledScript compile = scriptCompils.get(code);
			Object ret = compile.eval();
			return null == ret ? null : (T) parseNativeObject(ret);
		} catch (Exception e) {
			throw new RuntimeException("执行脚本失败：" + e.getMessage());
		}
	}

	@Override
	@SuppressWarnings("unchecked")
	public <T> T evalCompile(String code, Map<?, ?> params) {
		if(!scriptCompils.containsKey(code)) throw new RuntimeException("请先编译脚本。");
		try {
			CompiledScript compile = scriptCompils.get(code);
			Object ret = compile.eval(bind(params));
			return null == ret ? null : (T) parseNativeObject(ret);
		} catch (Exception e) {
			throw new RuntimeException("执行脚本失败：" + e.getMessage());
		}
	}
	
	public void compile(String code, String script){
		Compilable compilable = (Compilable) scriptEngine;
		try {
			CompiledScript compiled = compilable.compile(script);
			scriptCompils.put(code, compiled);
		} catch (Exception e) {
			throw new RuntimeException("编译脚本失败！");
		}
	}
	
	private Object parseNativeObject(Object obj) {
		if (obj == null) return null;
		try {
			if (MirrorCls.isAssignableFrom(obj.getClass())) {
				if ((boolean)isEmptyMethod.invoke(obj)){
					return null;
				}else if ((boolean)isArrayMethod.invoke(obj)) {
					Collection<?> arr = (Collection<?>) MirrorCls.getMethod("values").invoke(obj);
					List<Object> list = Lists.newArrayList();
					for(Object arrItem : arr){
						list.add(parseNativeObject(arrItem));
					}
					return list;
				}else{
					Map<String, Object> map = Maps.newHashMap();
					if((int)sizeMethod.invoke(obj) > 0){
						String[] keys = (String[])getOwnKeysMethod.invoke(obj, true);
						for(String key : keys) {
							Object subObj = getMethod.invoke(obj, key);
							map.put(key, parseNativeObject(subObj));
						}
					}
					return map;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return obj;
	}
	
	public static void main(String[] args) {
				
		/*
		ScriptEngineManager manager = new ScriptEngineManager();
		List<ScriptEngineFactory> factories = manager.getEngineFactories();
		for (ScriptEngineFactory factory : factories){
			System.out.println(factory.getNames() + ":" + factory.getExtensions());
		}
		*/
		
		NashornImpl eng = new NashornImpl();
		String s = eng.eval("'hello'");
		System.out.println(s + " : " + s.getClass().getName());
		Integer i = eng.eval("1 + 2");
		System.out.println(i + " : " + i.getClass().getName());
		Boolean b = eng.eval("1 > 0");
		System.out.println(b + " : " + b.getClass().getName());
		Double f = eng.eval("3.14");
		System.out.println(f + " : " + f.getClass().getName());
		Date d = eng.eval("EDate.getDate()");
		System.out.println(d + " : " + d.getClass().getName());
		List<Integer> ai = eng.eval("[1, 2, 3]");
		System.out.println(ai.get(1) + " : " + ai.getClass().getName());
		List<String> as = eng.eval("['A','B','C']");
		System.out.println(as.get(1) + " : " + as.getClass().getName());
		System.out.println(EJson.toJson(as));
		Map<String, Object> o = eng.eval("var json = {'id': 'netwild', 'age': 38}; json");
		System.out.println(o.get("id") + " : " + o.getClass().getName());
		System.out.println(EJson.toJson(o));
		List<Map<String, String>> ao = eng.eval("[{'id': 'netwild', 'age': 38},{'id': 'zmy', 'age': 26}]");
		System.out.println(ao.get(1).get("id") + " : " + ao.getClass().getName());
		System.out.println(EJson.toJson(ao));
		
		/*
		ERet params = ERet.create("id", "x").set("name", "netwild").set("roles", new String[]{"a", "b", "c"});
		StringBuilder sb = new StringBuilder();
		sb.append("var EUid = Java.type('itez.kit.EUid');");
		sb.append("var EStr = Java.type('itez.kit.EStr');");
		sb.append("var ENum = Java.type('itez.kit.ENum');");
		sb.append("var ECode = Java.type('itez.kit.ECode');");
		sb.append("var EHash = Java.type('com.jfinal.kit.HashKit');");
		sb.append("var EDate = Java.type('itez.kit.EDate');");
		sb.append("var ERegex = Java.type('itez.kit.ERegex');");
		sb.append("var EJson = Java.type('itez.kit.EJson');");
		sb.append("function submitBefor(params){");
		sb.append("	for(var i in params.roles){");
		sb.append("		if(i % 2 == 0) print( i + '：偶数');");
		sb.append("		else print( i + '：奇数');");
		sb.append("	}");
		sb.append("	return params;");
		sb.append("}");
		sb.append("submitBefor(binding);");
		
		eng.eval(sb.toString(), eng.bind("binding", params));
		//params = eng.getCompile("test", sb.toString(), eng.bind("binding", params));
		
		System.out.println(params);
		*/
	}

}
