package itez.kit.dbf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import com.jfinal.plugin.activerecord.Record;
import com.linuxense.javadbf.DBFDataType;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;

/**
 * <p>
 * DBF文件读写工具类
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年11月27日 下午7:14:34
 */
public class DbfKit {

	public static Dbf read(String path){
		File dbFile = new File(path);
		if(!dbFile.exists()) return null;
		InputStream fis = null;
		Dbf dbf = new Dbf();
		try {
            fis = new FileInputStream(dbFile);
            DBFReader reader = new DBFReader(fis);
            int fieldsCount = reader.getFieldCount();
            for (int i = 0; i < fieldsCount; i++) {
                DBFField field = reader.getField(i);
                dbf.addField(new DbfField(field.getName(), field.getName(), field.getType(), field.getLength()));
            }
            Object[] row;
            while ((row = reader.nextRecord()) != null) {
                for (int i = 0; i < fieldsCount; i++) {
                    Record rec = new Record();
                    rec.set(dbf.getFields().get(i).getCode(), row[i]);
                    dbf.addRow(rec);
                }
            }
            reader.close();
        } catch (Exception e) {
        	dbf.setError(e.getMessage());
        } finally {
            try {
                fis.close();
            } catch (Exception e) {
            }
        }
        return dbf;
	}

	public static void write(String path, Dbf dbf) {
		File dbFile = new File(path);
		if(dbFile.exists()) dbFile.delete();
		FileOutputStream fos = null;
		List<DbfField> fields = dbf.getFields();
		List<Record> recs = dbf.getRows();
		try {
			fos = new FileOutputStream(dbFile);
			DBFWriter writer = new DBFWriter(fos, dbf.getCharset());
			int fieldSize = fields.size();
			DBFField[] fieldArr = new DBFField[fieldSize];
			for(int i = 0; i < fieldSize; i++){
				DbfField f = fields.get(i);
				DBFField field = new DBFField();
				field.setName(f.getName());
				field.setType(f.getType());
				field.setLength(f.getLength());
				fieldArr[i] = field;
			}
			writer.setFields(fieldArr);
			recs.forEach(rec -> {
				Object[] row = new Object[fieldSize];
				for(int i = 0; i < fieldSize; i++){
					row[i] = rec.getObject(fields.get(i).getCode());
				}
				writer.addRecord(row);
			});
			writer.close();
		} catch (Exception e) {
			dbf.setError(e.getMessage());
        } finally {
			try {
				fos.close();
			} catch (IOException e) {
			}
		}
	}
	
	public static void main(String[] args) {
		String path = "D:/test3.dbf";
		Dbf dbf = new Dbf();
		dbf.addField(new DbfField("xm", "姓名", DBFDataType.CHARACTER, 20));
		dbf.addField(new DbfField("sfzh", "身份证号", DBFDataType.CHARACTER, 20));
		dbf.addField(new DbfField("ksh", "考生号", DBFDataType.CHARACTER, 20));
		dbf.addRow(new Record().set("xm", "张三").set("sfzh", "2101").set("ksh", "0001"));
		dbf.addRow(new Record().set("xm", "李四").set("sfzh", "2102").set("ksh", "0002"));
		dbf.addRow(new Record().set("xm", "王五").set("sfzh", "2103").set("ksh", "0003"));
		dbf.addRow(new Record().set("xm", "赵六").set("sfzh", "2104").set("ksh", "0004"));
		write(path, dbf);
		
		Dbf dbf1 = read(path);
		System.out.println(dbf1.getFields().size());
		System.out.println(dbf1.getRows().size());
	}
	
}
