package itez.kit.dbf;

import java.nio.charset.Charset;
import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.jfinal.plugin.activerecord.Record;

import itez.kit.EStr;

/**
 * <p>
 * DBF文件
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年11月28日 上午12:00:20
 */
public class Dbf {

	private List<DbfField> fields;
	private List<Record> rows;
	private Charset charset;
	private String error;
	
	public Dbf(){
		fields = Lists.newArrayList();
		rows = Lists.newArrayList();
		charset = EStr.GBK;
		error = null;
	}

	public Dbf addField(DbfField field){
		fields.add(field);
		return this;
	}

	public Dbf setFields(List<DbfField> fields){
		this.fields = fields;
		return this;
	}
	
	public Dbf addRow(Record row){
		rows.add(row);
		return this;
	}
	
	public Dbf setRows(List<Record> rows){
		this.rows = rows;
		return this;
	}
	
	public List<DbfField> getFields(){
		return fields;
	}
	
	public List<Record> getRows(){
		return rows;
	}
	
	public Charset getCharset() {
		return charset;
	}

	public void setCharset(Charset charset) {
		this.charset = charset;
	}

	public String getError() {
		return error;
	}

	public void setError(String error) {
		this.error = error;
	}
	
}
