package itez.kit.cache;

import java.util.HashSet;
import java.util.Set;

import com.jfinal.plugin.ehcache.IDataLoader;

import itez.kit.ELog;
import itez.kit.log.ELogBase;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

@SuppressWarnings("unchecked")
public class EhcacheImpl implements ICache {

	private static final ELogBase log = ELog.log(EhcacheImpl.class);
	private CacheManager cacheManager;
	private static Object locker = new Object();
    private CacheEventListener cacheEventListener;

	public EhcacheImpl() {
		System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
		cacheManager = CacheManager.create();
		log.info("创建默认CacheManager");
	}

	public EhcacheImpl(CacheManager cacheManager) {
		this.cacheManager = cacheManager;
	}

	public CacheManager getCacheManager() {
		return this.cacheManager;
	}
	
	public Cache getOrAddCache(String cacheName) {
		Cache cache = cacheManager.getCache(cacheName);
		if (cache == null) {
			synchronized (locker) {
				cache = cacheManager.getCache(cacheName);
				if (cache == null) {
					//log.warn("未找到CacheName：{}，将自动创建该Cache。", cacheName);
					cacheManager.addCacheIfAbsent(cacheName);
					cache = cacheManager.getCache(cacheName);
				}
			}
		}
		return cache;
	}

	@Override
	public boolean has(String cacheName, Object key) {
		Cache cache = getOrAddCache(cacheName);
		if(cache.isKeyInCache(key) && cache.getQuiet(key) != null){
			return true;
		}
		return false;
	}

	@Override
	public <T> T get(String cacheName, Object key) {
		Element element = getOrAddCache(cacheName).get(key);
		return element != null ? (T) element.getObjectValue() : null;
	}

	@Override
	public void put(String cacheName, Object key, Object value) {
		put(cacheName, key, value, 0);
	}

	@Override
	public void put(String cacheName, Object key, Object value, Integer liveSeconds) {
		Element element = new Element(key, value);
		if (liveSeconds > 0) {
			element.setTimeToIdle(liveSeconds);
		}
		getOrAddCache(cacheName).put(element);
	}

	@Override
	public void remove(String cacheName, Object key) {
		log.info("清除缓存条目：cacheName（{}），key（{}）", cacheName, key);
		getOrAddCache(cacheName).remove(key);
	}

	@Override
	public void removeAll(String cacheName) {
		log.info("清除缓存区域：cacheName（{}）", cacheName);
		getOrAddCache(cacheName).removeAll();
	}

	@Override
	public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
		Object data = get(cacheName, key);
		if (data == null) {
			data = dataLoader.load();
			put(cacheName, key, data);
		}
		return (T) data;
	}

	@Override
	public <T> T get(String cacheName, Object key, IDataLoader dataLoader, Integer liveSeconds) {
		if (liveSeconds <= 0) {
			return get(cacheName, key, dataLoader);
		}
		Object data = get(cacheName, key);
		if (data == null) {
			data = dataLoader.load();
			put(cacheName, key, data, liveSeconds);
		}
		return (T) data;
	}

	@Override
	public Integer getTtl(String cacheName, Object key) {
		Element element = getOrAddCache(cacheName).get(key);
		return element != null ? element.getTimeToLive() : null;
	}

	@Override
	public void setTtl(String cacheName, Object key, Integer seconds) {
		Element element = getOrAddCache(cacheName).get(key);
		if (element == null) {
			return;
		}
		element.setTimeToIdle(seconds);
		getOrAddCache(cacheName).put(element);
	}

	@Override
	public Set<String> getKeys(String cacheName) {
		return new HashSet<String>(getOrAddCache(cacheName).getKeys());
	}

    public CacheEventListener getCacheEventListener() {
        return cacheEventListener;
    }

    public void setCacheEventListener(CacheEventListener cacheEventListener) {
        this.cacheEventListener = cacheEventListener;
    }

}
