package itez.kit.async;

import itez.kit.ERet;
import itez.kit.EUid;

public class AsyncState {
	
	String id;
	long start;
	long end;
	long times;
	boolean state;
	ICallBack callback = null;
	ERet ret = null;
	
	AsyncState() {
		id = EUid.generator();
		start = System.currentTimeMillis();
		end = 0;
		times = 0;
		state = false;
	}
	
	AsyncState(ICallBack callback) {
		id = EUid.generator();
		start = System.currentTimeMillis();
		end = 0;
		times = 0;
		state = false;
		this.callback = callback;
	}
	
	public AsyncState complate(){
		return complate(ERet.ok());
	}
	
	public AsyncState complate(ERet ret){
		end = System.currentTimeMillis();
		times = this.end - this.start;
		state = true;
		this.ret = ret;
		if(callback != null) callback.callback(this);
		return this;
	}

	public String getId() {
		return id;
	}

	public long getStart() {
		return start;
	}

	public long getEnd() {
		return end;
	}

	public long getTimes() {
		return times;
	}

	public boolean getState() {
		return state;
	}

	public ICallBack getCallback() {
		return callback;
	}

	public ERet getRet() {
		return ret;
	}
}
