package itez.kit;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;

import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.bouncycastle.jce.provider.BouncyCastleProvider;

/**
 * 国密工具
 * @author netwild
 *
 */
public class SM4Kit {

	private static final String ALGORITHM_NAME = "SM4";
	private static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
	private static final String PROVIDER_NAME = "BC";
		   
	private static final int ENCRYPT_MODE = 1;
	private static final int DECRYPT_MODE = 2;
	private static final int DEFAULT_KEY_SIZE = 16;
	
	static {
		Security.addProvider(new BouncyCastleProvider());
	}
	
	/**
	 * 加密（默认采用CBC模式，更安全）
	 * @param data 明文
	 * @param key 密钥
	 * @return
	 */
	public static String encrypt(String data, String key){
		try {
			byte[] originalBytes = data.getBytes(EStr.UTF_8);
			Cipher cipher = generateCipher(ENCRYPT_MODE, key);
			byte[] cipherText = cipher.doFinal(originalBytes);
			return EBase64.encode(cipherText);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 解密（默认采用CBC模式，更安全）
	 * @param cipherText 密文
	 * @param key 密钥
	 * @return
	 */
	public static String decrypt(String cipherText, String key){
		try {
			byte[] cipherBytes = EBase64.decode2byte(cipherText);
			Cipher cipher = generateCipher(DECRYPT_MODE, key);
			byte[] originalBytes = cipher.doFinal(cipherBytes);
			return new String(originalBytes, EStr.UTF_8);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	/**
	 * 初始化Cipher
	 * @param mode
	 * @param key
	 * @return
	 * @throws NoSuchAlgorithmException
	 * @throws NoSuchProviderException
	 * @throws NoSuchPaddingException
	 * @throws InvalidKeyException
	 * @throws InvalidAlgorithmParameterException
	 */
	private static Cipher generateCipher(int mode, String key) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException{
		byte[] originalKey = formatKey(key);
		Key sm4Key = new SecretKeySpec(originalKey, ALGORITHM_NAME);
		Cipher cipher = Cipher.getInstance(ALGORITHM_NAME_CBC_PADDING, PROVIDER_NAME);
		IvParameterSpec ivParameterSpec = new IvParameterSpec(getIV());
		cipher.init(mode, sm4Key, ivParameterSpec);
		return cipher;
	}
	
	/**
	 * 自动补齐密钥（128位，16个字节）
	 * @param key
	 * @return
	 */
	private static byte[] formatKey(String key){
		byte[] originalKey = key.getBytes(EStr.UTF_8);
		int originalLen = originalKey.length;
		if(originalLen > DEFAULT_KEY_SIZE){
			byte[] retKey = new byte[DEFAULT_KEY_SIZE];
			for(int i = 0; i < DEFAULT_KEY_SIZE; i++){
				retKey[i] = originalKey[i];
			}
			return retKey;
		}else if(originalLen < DEFAULT_KEY_SIZE){
			byte[] retKey = new byte[DEFAULT_KEY_SIZE];
			for(int i = 0; i < DEFAULT_KEY_SIZE; i++){
				retKey[i] = i < originalLen ? originalKey[i] : 0;
			}
			return retKey;
		}else
			return originalKey;
	}
	
	/**
	 * 生成IV，要求必须为16个字节长度
	 * @return
	 */
	private static byte[] getIV() {
		String iv = "1irN#nj*W51e6$&^";
		return iv.getBytes();
	}
	
	public static void main(String[] args) {
		String origin = "netwild";
		String key = "abc";
		String cipher = SM4Kit.encrypt(origin, key);
		String destr = SM4Kit.decrypt(cipher, key);
		System.out.println("原文：" + origin);
		System.out.println("加密：" + cipher);
		System.out.println("解密：" + destr);
	}
	
}
