package itez.kit;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import com.google.common.collect.Maps;
//import com.jfinal.core.Injector;
import com.jfinal.kit.HttpKit;
import com.jfinal.upload.MultipartRequest;
import com.jfinal.upload.UploadFile;

import itez.core.runtime.EContext;
import itez.core.util.inject.Injector;
import itez.core.wrapper.controller.HTTP;
import itez.kit.fileup.EFileKit;
import itez.kit.restful.EMap;
import itez.kit.rsa.RsaKit;

public class EPara {

	private HttpServletRequest request;
	private Map<String, File> fileObjs = Maps.newHashMap();
	private Map<String, String> filePaths = Maps.newHashMap();
	private HTTP http;
	private Boolean autoLoad = true;
	private String fileSubPath = null;
	private Boolean multiPart = false;
	private String rawData = null;
	
	public EPara(HttpServletRequest request){
		init(request, true, null);
	}
	
	public EPara(HttpServletRequest request, boolean autoUpload){
		init(request, autoUpload, null);
	}
	
	public EPara(HttpServletRequest request, String fileSubPath){
		init(request, true, fileSubPath);
	}
	
	public void init(HttpServletRequest request, boolean autoUpload, String fileSubPath){
		this.request = request;
		this.http = HTTP.valueOf(request.getMethod().toUpperCase());
		this.autoLoad = autoUpload;
		this.fileSubPath = fileSubPath;
		initFiles();
	}
	
	public EPara(HttpServletRequest request, boolean autoUpload, String fileSubPath){
		this.request = request;
		this.http = HTTP.valueOf(request.getMethod().toUpperCase());
		this.autoLoad = autoUpload;
	}
	
	public void initFiles(){
		String contentType = request.getContentType();
		if(contentType !=null && contentType.toLowerCase().contains("multipart")) multiPart = true;
		if(multiPart){
			request = new MultipartRequest(request);
			List<UploadFile> uploads = ((MultipartRequest)request).getFiles();
			uploads.forEach(upload -> {
				if(upload != null){
					fileObjs.put(upload.getParameterName(), upload.getFile());
				}
			});
		}
		if(autoLoad) upload();
	}

	public void upload(){
		upload(null);
	}

	public void upload(String fileSubPath){
		if(EStr.isEmpty(fileSubPath)) fileSubPath = this.fileSubPath;
		if(EStr.isEmpty(fileSubPath)) fileSubPath = EContext.getAttr().getModuleCode();
		String storePath = String.join("/", EContext.getAttr().getDomain(), fileSubPath);
		if(multiPart){
			fileObjs.forEach((paramName, file) -> {
				String uploadPath = EFileKit.upload(file, storePath);
				filePaths.put(paramName, uploadPath);
			});
		}
	}

	public String getRawData() {
		if(rawData == null){
			rawData = HttpKit.readData(request);
		}
		return rawData;
	}
	public EMap getParas(){
		EMap map = EMap.create();
		Enumeration<String> keys = request.getParameterNames();
		while(keys.hasMoreElements()){
			String key = keys.nextElement();
			String val = null;
			String[] values = request.getParameterValues(key);
			if(values != null && values.length > 0) val = Arrays.stream(values).collect(Collectors.joining(","));
			map.set(key, val);
		}
		filePaths.forEach((paramName, path) -> {
			map.set(paramName, path);
		});
		return map;
	}
	public String get(String name) {
		return request.getParameter(name);
	}
	public String get(String name, String defaultValue) {
		return EStr.ifEmpty(get(name), defaultValue);
	}
	public Integer getInt(String name) {
		return toInt(get(name), null);
	}
	public Integer getInt(String name, Integer defaultValue) {
		return toInt(get(name), defaultValue);
	}
	public Boolean getBoolean(String name) {
		return toBoolean(get(name), null);
	}
	public Boolean getBoolean(String name, Boolean defaultValue) {
		return toBoolean(get(name), defaultValue);
	}
	public Date getDate(String name) {
		return toDate(get(name), null);
	}
	public Date getDate(String name, Date defaultValue) {
		return toDate(get(name), defaultValue);
	}
	public Date getDateTime(String name) {
		return toDateTime(get(name), null);
	}
	public Date getDateTime(String name, Date defaultValue) {
		return toDateTime(get(name), defaultValue);
	}
	public Double getDouble(String name){
		return toDouble(get(name), null);
	}
	public Double getDouble(String name, Double defaultValue){
		return toDouble(get(name), defaultValue);
	}
	
	public String[] getValues(String name) {
		return request.getParameterValues(name);
	}
	public Integer[] getValuesInt(String name) {
		String[] values = getValues(name);
		if (values == null || values.length == 0) return null;
		Integer[] result = new Integer[values.length];
		for (int i=0; i<result.length; i++) result[i] = toInt(values[i], null);
		return result;
	}
	public Boolean[] getValuesBoolean(String name) {
		String[] values = getValues(name);
		if (values == null || values.length == 0) return null;
		Boolean[] result = new Boolean[values.length];
		for (int i=0; i<result.length; i++) result[i] = toBoolean(values[i], null);
		return result;
	}
	public Date[] getValuesDate(String name) {
		String[] values = getValues(name);
		if (values == null || values.length == 0) return null;
		Date[] result = new Date[values.length];
		for (int i=0; i<result.length; i++) result[i] = toDate(values[i], null);
		return result;
	}
	public Double[] getValuesDouble(String name) {
		String[] values = getValues(name);
		if (values == null || values.length == 0) return null;
		Double[] result = new Double[values.length];
		for (int i=0; i<result.length; i++) result[i] = toDouble(values[i], null);
		return result;
	}
	public File getFileObj(String name){
		return fileObjs.get(name);
	}
	public String getFile(String name){
		return filePaths.get(name);
	}
	public <T> T getModel(Class<T> beanClass){
		return getModel(beanClass, false);
	}
	public <T> T getModel(Class<T> beanClass, boolean skipConvertError){
		//return (T)Injector.injectBean(beanClass, "", request, skipConvertError);
		return (T)Injector.injectBean(beanClass, "", getParas(), skipConvertError);
	}
	
	private Integer toInt(String value, Integer defaultValue) {
		try {
			if (EStr.isEmpty(value)) return defaultValue;
			value = value.trim();
			if (value.startsWith("N") || value.startsWith("n")) return -Integer.parseInt(value.substring(1));
			return Integer.parseInt(value);
		}
		catch (Exception e) {
			throw new RuntimeException("Can not parse the parameter \"" + value + "\" to Integer value.");
		}
	}
	private Boolean toBoolean(String value, Boolean defaultValue) {
		if (EStr.isEmpty(value)) return defaultValue;
		value = value.trim().toLowerCase();
		if ("1".equals(value) || "true".equals(value)) return Boolean.TRUE;
		else if ("0".equals(value) || "false".equals(value)) return Boolean.FALSE;
		throw new RuntimeException("Can not parse the parameter \"" + value + "\" to Boolean value.");
	}
	private Date toDate(String value, Date defaultValue) {
		try {
			if (EStr.isEmpty(value)) return defaultValue;
			return new java.text.SimpleDateFormat("yyyy-MM-dd").parse(value.trim());
		} catch (Exception e) {
			throw new RuntimeException("Can not parse the parameter \"" + value + "\" to Date value.");
		}
	}
	private Date toDateTime(String value, Date defaultValue) {
		try {
			if (EStr.isEmpty(value)) return defaultValue;
			return new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value.trim());
		} catch (Exception e) {
			throw new RuntimeException("Can not parse the parameter \"" + value + "\" to Date value.");
		}
	}
	private Double toDouble(String value, Double defaultValue){
		try {
			if(EStr.isEmpty(value)) return defaultValue;
			return Double.valueOf(value.trim());
		} catch (Exception e) {
			throw new RuntimeException("Can not parse the parameter \"" + value + "\" to Double value.");
		}
	}

	@SuppressWarnings("unchecked")
	public <T> T getAttr(String attrName){
		Object o = request.getAttribute(attrName);
		if(o == null) return null;
		return (T) o;
	}
	
	public HttpServletRequest getRequest() {
		return request;
	}
	
	public HTTP getHttp() {
		return http;
	}

	public Boolean getMultiPart() {
		return multiPart;
	}
	
	/**
	 * <p>
	 * 返回净化之后的参数值
	 * </p>
	 * 
	 * @param name
	 * @return
	 */
	public String getClean(String name) {
		return getClean(name, null);
	}
	/**
	 * <p>
	 * 返回净化之后的参数值
	 * </p>
	 * 
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public String getClean(String name, String defaultValue) {
		String val = get(name, defaultValue);
		return EClean.clean(val, EClean.text);
	}
	/**
	 * <p>
	 * 返回净化并解密之后的参数值
	 * </p>
	 * 
	 * @param name
	 * @return
	 */
	public String getDecrypt(String name) {
		return getDecrypt(name, null);
	}
	/**
	 * <p>
	 * 返回净化并解密之后的参数值
	 * </p>
	 * 
	 * @param name
	 * @param defaultValue
	 * @return
	 */
	public String getDecrypt(String name, String defaultValue) {
		String val = get(name, defaultValue);
		return RsaKit.decryptByDefPrivateKey(val);
	}
		
}
