package itez.kit;

import itez.kit.json.EJsonFactory;
import itez.kit.json.EJsonFomat;

/**
 * JSON序列化/反序列化工具类
 * @author netwild
 *
 */
public class EJson {

	/**
	 * 将对象转换为JSON字符串（序列化）
	 * @param object 待转换的对象
	 * @return JSON字符串
	 */
	public static String toJson(Object object) {
		return EJsonFactory.me.getJson().toJson(object);
	}
	
	/**
	 * 将对象转换未JSON字符串（序列化），同时指定保留的属性列表
	 * @param object 待转换的对象
	 * @param properties 保留的属性列表
	 * @return JSON字符串
	 */
	public static String toJsonFilter(Object object, String... properties){
		return EJsonFactory.me.getJson().toJsonFilter(object, properties);
	}
	
	/**
	 * 将JSON字符串解析成指定的对象（反序列化）
	 * @param <T> 类型
	 * @param jsonString 待解析的JSON字符串
	 * @param type 对象类型
	 * @return 解析之后的对象实例
	 */
	public static <T> T parse(String jsonString, Class<T> type) {
		return EJsonFactory.me.getJson().parse(jsonString, type);
	}
	
	/**
	 * 对JSON字符串进行格式化
	 * @param jsonString 待格式化的JSON字符串
	 * @return 格式化之后的JSON字符串
	 */
	public static String format(String jsonString){
		return EJsonFomat.format(jsonString);
	}
	
	/**
	 * 对JSON字符串进行压缩
	 * @param jsonString 待压缩的JSON字符串
	 * @return 已压缩的JSON字符串
	 */
	public static String compress(String jsonString){
		return EJsonFomat.compress(jsonString);
	}

}
