package itez.kit;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.File;
 
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
 
/**
 * 图片剪切工具类
 */
public class EImageCrop{
	
	/**
	 * <p>
	 * 图片剪切
	 * </p>
	 * 
	 * @param base64Src 原始文件的Base64格式
	 * @param x 左上角X位置
	 * @param y 左上角Y位置
	 * @param w 截取宽度
	 * @param h 截取高度
	 * @return 剪切之后的图片Base64编码
	 */
	public static String crop(String base64Src, int x, int y, int w, int h) {
        try {
			String extName = EBase64.getImgType(base64Src);
			base64Src = EBase64.removePrefix(base64Src);
			byte[] bySrc = EBase64.decode2byte(base64Src);
			
			Image image = new ImageIcon(bySrc).getImage();
	        int wid = image.getWidth(null);
	        int hei = image.getHeight(null);
	        if(x + w > wid) w = wid - x;
	        if(y + h > hei) h = hei - y;
	
	        BufferedImage imgFull = toBufferedImage(image);
	        BufferedImage imgDist = imgFull.getSubimage(x, y, w, h);
	        ByteArrayOutputStream os = new ByteArrayOutputStream();
	        ImageIO.write(imgDist, extName, os);
	        byte[] byDist = os.toByteArray();
	        String base64Dist = EBase64.encode(byDist);
	        base64Dist = EBase64.addPrefix(base64Dist, extName);
	        return base64Dist;
        } catch (Exception e) {
            e.printStackTrace();
        	return null;
        }
	}
 
    /**
     * 图片剪切
     * @param source 原始文件
     * @param target 目标文件
     * @param x X坐标
     * @param y Y坐
     * @param w 宽度
     * @param h 高度
     */
    public static void crop(File source, File target, int x, int y, int w, int h) {
        try {
        	String pathSrc = source.getAbsolutePath();
        	String pathTar = target.getAbsolutePath();
        	int ind = pathTar.lastIndexOf(".");
        	String extName = ind > 0 ? pathTar.substring(ind + 1) : "jpg";
 
            Image image = new ImageIcon(pathSrc).getImage();
            int wid = image.getWidth(null);
            int hei = image.getHeight(null);
            if(x + w > wid) w = wid - x;
            if(y + h > hei) h = hei - y;
            
            BufferedImage outImage = toBufferedImage(image);
            BufferedImage img = outImage.getSubimage(x, y, w, h);
            ImageIO.write(img, extName, target);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
 
    private static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) return (BufferedImage) image;
        // This code ensures that all the pixels in the image are loaded
        image = new ImageIcon(image).getImage();
        // Determine if the image has transparent pixels; for this method's
        // implementation, see e661 Determining If an Image Has Transparent
        // Pixels
        boolean hasAlpha = hasAlpha(image);
        // boolean hasAlpha = false;
        // Create a buffered image with a format that's compatible with the
        // screen
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            // Determine the type of transparency of the new buffered image
            int transparency = hasAlpha ? Transparency.BITMASK : Transparency.OPAQUE;
            // Create the buffered image
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        } catch (HeadlessException e) {
            // The system does not have a screen
        }
        if (bimage == null) {
            // Create a buffered image using the default color model
            int type = hasAlpha ? BufferedImage.TYPE_INT_ARGB : BufferedImage.TYPE_INT_RGB;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        // Copy image to buffered image
        Graphics g = bimage.createGraphics();
        // Paint the image onto the buffered image
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }
 
    // This method returns true if the specified image has transparent pixels
    private static boolean hasAlpha(Image image) {
        // If buffered image, the color model is readily available
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage) image;
            return bimage.getColorModel().hasAlpha();
        }
        // Use a pixel grabber to retrieve the image's color model;
        // grabbing a single pixel is usually sufficient
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        } catch (InterruptedException e) {
        }
        // Get the image's color model
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    /*
    public static void main(String[] args) {
    	String source = "D:\\docs\\project\\学工\\华东理工大学.jpg";//开普学工架构图.png";
    	String target = "D:\\docs\\project\\学工\\开普学工架构图1.png";
        EImageCrop.crop(new File(source), new File(target), 100, 100, 200, 200);
    }
    */
 
}