package itez.kit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ECookie {

	public static final int MAX_AGE_HALF_HOUR = 30 * 60; //半小时
	public static final int MAX_AGE_WEEK = 7 * 24 * 3600; //一周
	public static final int MAX_AGE_MONTH = 30 * 24 * 3600; //一个月
	public static final int MAX_AGE_YEAR = 365 * 24 * 3600; //一年
	
	private static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
		Map<String, Cookie> cookieMap = new HashMap<String, Cookie>();
		Cookie[] cookies = request.getCookies();		
		if (null != cookies) {
			cookieMap = Arrays.stream(cookies).collect(Collectors.toMap(Cookie::getName, c -> c, (key1 , key2)-> key2));
		}
		return cookieMap;
	}
	
	/**
	 * 添加Cookie
	 * @param response
	 * @param name
	 * @param value
	 * @param maxValues
	 */
	public static void setCookie(HttpServletResponse response, String name, String value, int maxValues, TimeUnit unit) {
		if (EStr.isEmpty(name)) return;
		if (EStr.isNull(value)) value = "";
		Cookie cookie = new Cookie(name, value);
		cookie.setPath("/");
		cookie.setHttpOnly(true);
		cookie.setMaxAge(maxValues == 0 ? MAX_AGE_HALF_HOUR : (int)unit.toSeconds(maxValues));
		response.addCookie(cookie);
	}
	
	/**
	 * 获取指定name的Cookie值
	 * @param response
	 * @param name
	 * @return
	 */
	public static String getCookie(HttpServletRequest request, String name){
		Map<String, Cookie> map = readCookieMap(request);
		if(map.containsKey(name)){
			Object val = map.get(name).getValue();
			if(val != null) return val.toString();
			else return null;
		}else{
			return null;
		}
	}
	
	/**
	 * 删除指定name的Cookie
	 * @param request
	 * @param name
	 */
	public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name){
		Map<String, Cookie> map = readCookieMap(request);
		if(map.containsKey(name)){
			Cookie cookie = map.get(name);
			cookie.setValue(null);
			cookie.setPath("/");
			cookie.setMaxAge(0);
			response.addCookie(cookie);
		}
	}
	
}
