package itez.kit;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Random;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import com.jfinal.kit.HashKit;

/**
 * 字符串编码、解码类
 * 
 * @author netwild
 *
 */
public class ECode {

	private static final String CHARSET = "UTF-8";
	private static final String KEY_ALGORITHM = "AES";
	private static final String CIPHER_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";

	private static final String chrDis = "0123456789"; //10个
	private static final String chrIcs = "!@#$%*"; //6个
	private static final String chrEnLo = "abcdefghijklmnopqrstuvwxyz"; //26个
	private static final String chrEnUp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"; //26个

	private static final String SYMBOLS = "0123456789";      //验证码字胆
    private static final Random RANDOM = new SecureRandom(); //随机实例

	/**
	 * <p>
	 * 返回随机密码
	 * </p>
	 * 
	 * @param len 密码长度（应设置奇数）
	 * @return 新的随机密码
	 */
	public static String getRandomPass(int len) {
		int diCnt = len / 2;
		int enCnt = (len - diCnt - 1) / 2;
		StringBuffer sb = new StringBuffer();
		for(int i = 0; i < diCnt; i++) sb.append(chrDis.charAt(EStr.rand(0, 9)));
		sb.append(chrIcs.charAt(EStr.rand(0, 5)));
		for(int i = 0; i < enCnt; i++) sb.append(chrEnLo.charAt(EStr.rand(0, 25))).append(chrEnUp.charAt(EStr.rand(0, 25)));
		return sb.toString();
	}
	
	/**
	 * MD5加密
	 * @param str 待加密的字符串
	 * @return 已解密的字符串
	 */
	public static String md5(String str){
		String md5 = HashKit.md5(str);
		return md5;
	}
	
	/**
	 * 生成私盐
	 * @param len 私盐长度
	 * @return 私盐字符串
	 */
	public static String generateSalt(int len){
		String salt = HashKit.generateSalt(len);
		return salt;
	}
	
	/**
	 * AES加密
	 * @param str 待加密字符串
	 * @param key 密钥，要求必须为16个字节长度
	 * @return 加密之后的字符串
	 */
	public static String AESEncode(String str, String key) {
		try {
			byte[] strs = str.getBytes(CHARSET);
			byte[] keys = key.getBytes(CHARSET);
			Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
			SecretKeySpec skeySpec = new SecretKeySpec(keys, KEY_ALGORITHM);
			IvParameterSpec iv = new IvParameterSpec(getIV());
			cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);
			byte[] encrypted = cipher.doFinal(strs);
			String encode = EBase64.encode(encrypted);
			return encode;
		} catch (Exception e) {
			return null;
		}
	}
	
	/**
	 * AES解密
	 * @param str 待解密的字符串
	 * @param key 密钥，要求必须为16个字节长度
	 * @return 解密之后的字符串
	 */
	public static String AESDecode(String str, String key){
		try{
			byte[] strs = str.getBytes(CHARSET);
			byte[] keys = key.getBytes(CHARSET);
			Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_CBC);
			SecretKeySpec skeySpec = new SecretKeySpec(keys, KEY_ALGORITHM);
			IvParameterSpec iv = new IvParameterSpec(getIV());
			cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
			byte[] encrypted = EBase64.decode2byte(strs);
			byte[] original = cipher.doFinal(encrypted);
			return new String(original, CHARSET);
		} catch (Exception e) {
			return null;
		}
	}
    
	/**
	 * 生成IV，要求必须为16个字节长度
	 * @return
	 */
	private static byte[] getIV() {
		String iv = "1j*W1i#n5N$e6r&^";
		return iv.getBytes();
	}

	/**
	 * 对URL进行URLEncoder编码
	 * @param src 原地址
	 * @return 编码后的地址
	 */
	public static String URLEncode(String src) {
		String requestValue = "";
		try {
			requestValue = URLEncoder.encode(src, CHARSET);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return requestValue;
	}

	/**
	 * 对URL进行URLDecode解码
	 * @param src 待解码地址
	 * @return 解码后的地址
	 */
	public static String URLDecode(String src) {
		String requestValue = "";
		try {
			requestValue = URLDecoder.decode(src, CHARSET);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return requestValue;
	}
	
	/**
	 * 生成随机验证码，默认6位数字
	 * @return
	 */
	public static String generateValiCode(){
		return generateValiCode(6);
	}
	
	/**
	 * 生成随机验证码
	 * @param len 位数
	 * @return
	 */
	public static String generateValiCode(int len){
		char[] chars = new char[len];
		for (int i = 0; i < chars.length; ++i) {
			chars[i] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
		}
		return new String(chars);
	}

}
