package itez.kit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

/**
 * <p>
 * 参数过滤，主要用于解决XSS非法字符
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年10月14日 上午10:20:04
 */
public class EClean {

	//纯文本清单
	public static Whitelist text;
	
	//基本清单（含图片标签）
	public static Whitelist basicWithImages;
	
	static {
		text = Whitelist.none();
		basicWithImages = Whitelist.basic().addTags("img").addAttributes("img", "align", "alt", "height", "src", "title", "width");
	}
	
	/**
	 * <p>
	 * 从参数中返回合法的URL，避免XSS注入
	 * </p>
	 * 
	 * @param param 待过滤的URL地址串
	 * @return 过滤之后的URL地址串
	 */
	public static String filterUrl(String param){
		if(EStr.isEmpty(param)) return "";
		String ptnStr = "^(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";
		Pattern ptn = Pattern.compile(ptnStr);
		Matcher mach = ptn.matcher(param);
		if(mach.find()) return mach.group();
		else return "";
	}
	
	/**
	 * 过滤XSS非法字符
	 * @param param 待过滤的字符串
	 * @param whiteList 白名单列表
	 * @return 过滤之后的字符串
	 */
	public static String clean(String param, Whitelist whiteList) {
		if(null == param) return null;
		param = Jsoup.clean(param, whiteList);
		return param;
	}
	
}
